<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6120"
	title	= "JfreeChart"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>
<og:value command="SQL">
	<jsp:text>
		SELECT 	 count(*)*100 GRAPH_WIDTH
		FROM EMP
		<og:where>
			<og:and value=" DEPTNO = {@SOOUID}" />
		</og:where>
	</jsp:text>
</og:value>
<!--  -->
<og:chartCreate
	title			= "{@LBL.KNORDER}"
	width			= "{@GRAPH_WIDTH}"
	height			= "600"
	plotOrientation	= "{@plotOrientation}"
>
	<og:chartDataset
		chartType	  = "HybsBar"
		barItemMargin = "0"
	>
		<jsp:text>
			SELECT 	 ENAME							<!-- 営業担当者 -->
					,SAL		JANUARY				<!-- 売上( 1月) -->
					,SAL*1.2	FEBRUARY			<!-- 売上( 2月) -->
			FROM EMP A
		</jsp:text>
	</og:chartDataset>
	<og:chartDataset
		chartType			= "HybsLine"
		shapesVisible		= "false"
		valueLabelsVisible	= "false"
	>
		<jsp:text>
			SELECT 	 ENAME								<!-- 営業担当者 -->
					,(SELECT AVG( SAL ) FROM EMP WHERE DEPTNO = '10')		SALARY_AVG1		<!-- 売上( 1月) -->
			FROM EMP
		</jsp:text>
	</og:chartDataset>
	<og:chartDataset
		chartType			= "HybsLine"
		shapesVisible		= "false"
		valueLabelsVisible	= "false"
	>
		<jsp:text>
			SELECT 	 ENAME								<!-- 営業担当者 -->
					,(SELECT AVG( SAL*1.5 ) FROM EMP WHERE DEPTNO = '20')		SALARY_AVG2		<!-- 売上( 1月) -->
			FROM EMP
		</jsp:text>
	</og:chartDataset>
	<og:chartDataset
		chartType			= "HybsLine"
		shapesVisible		= "false"
		valueLabelsVisible	= "false"
	>
		<jsp:text>
			SELECT 	 ENAME							<!-- 営業担当者 -->
					,(SELECT AVG( SAL*2 ) FROM EMP WHERE DEPTNO = '30')		SALARY_AVG3		<!-- 売上( 1月) -->
			FROM EMP
		</jsp:text>
	</og:chartDataset>
</og:chartCreate>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
