/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.plugin.io.TableReader_Default;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TableReader_Calc
extends TableReader_Default {
    private static final String VERSION = "4.0.0 (2009/01/05)";
    private String sheetName = null;
    private String sheetNos = null;
    private String filename = null;
    private int numberOfRows = 0;
    private int firstClmIdx = 0;
    private int[] valueClmIdx = null;

    @Override
    public void readDBTable() {
        Object object;
        ZipFile zipFile = null;
        boolean bl = false;
        try {
            zipFile = new ZipFile(this.filename);
            object = zipFile.getEntry("content.xml");
            if (null == object) {
                String string = "ODS\u30d5\u30a1\u30a4\u30eb\u4e2d\u306b\u30d5\u30a1\u30a4\u30ebcontent.xml\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
                throw new HybsSystemException(string);
            }
            DomOdsParser domOdsParser = new DomOdsParser();
            domOdsParser.doParse(zipFile.getInputStream((ZipEntry)object), this.sheetName, this.sheetNos);
            List<RowInfo> list = domOdsParser.getRowInfoList();
            this.makeDBTableModel(list.toArray(new RowInfo[list.size()]));
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + this.filename + "]";
                throw new HybsSystemException(string, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                bl = !Closer.zipClose(zipFile);
                throw throwable;
            }
        }
        bl = !Closer.zipClose((ZipFile)zipFile);
        if (bl) {
            object = "ODS\u30d5\u30a1\u30a4\u30eb\u306e\u30af\u30ed\u30fc\u30ba\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f[" + this.filename + "]";
            throw new HybsSystemException((String)object);
        }
    }

    @Override
    public void readDBTable(BufferedReader bufferedReader) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        throw new UnsupportedOperationException(string);
    }

    public void setSheetName(String string) {
        this.sheetName = string;
    }

    public void setSheetNos(String string) {
        this.sheetNos = string;
    }

    public boolean isExcel() {
        return true;
    }

    public void setFilename(String string) {
        this.filename = string;
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }

    private void makeDBTableModel(RowInfo[] rowInfoArray) {
        int n;
        if (this.columns != null && this.columns.length() > 0) {
            this.makeHeaderFromClms();
        }
        for (int i = n = this.getSkipRowCount(); i < rowInfoArray.length; ++i) {
            RowInfo rowInfo = rowInfoArray[i];
            if (this.valueClmIdx == null) {
                this.makeHeader(rowInfo);
                continue;
            }
            this.makeBody(rowInfo);
        }
        if (this.valueClmIdx == null) {
            String string = "\u6700\u5f8c\u307e\u3067\u3001#NAME \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + "\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u304b\u3001\u3082\u3057\u304f\u306f\u640d\u50b7\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" + HybsSystem.CR;
            throw new HybsSystemException(string);
        }
    }

    private void makeHeaderFromClms() {
        this.table = DBTableModelUtil.newDBTable();
        String[] stringArray = StringUtil.csv2Array((String)this.columns);
        this.table.init(stringArray.length);
        this.setTableDBColumn(stringArray);
        this.valueClmIdx = new int[stringArray.length];
        int n = this.isUseNumber() ? 1 : 0;
        for (int i = 0; i < stringArray.length; ++i) {
            this.valueClmIdx[i] = n++;
        }
    }

    private void makeHeader(RowInfo rowInfo) {
        String[] stringArray;
        int n;
        CellInfo[] cellInfoArray = rowInfo.cellInfos;
        int n2 = cellInfoArray.length;
        int n3 = 0;
        ArrayList<String> arrayList = null;
        ArrayList<Integer> arrayList2 = null;
        for (n = 0; n < n2; ++n) {
            stringArray = cellInfoArray[n];
            String string = stringArray.text.trim();
            for (int i = 0; i < stringArray.colRepeat; ++i) {
                if (string.length() != 0) {
                    if (this.firstClmIdx == 0 && string.equalsIgnoreCase("#NAME")) {
                        arrayList = new ArrayList<String>();
                        arrayList2 = new ArrayList<Integer>();
                        this.table = DBTableModelUtil.newDBTable();
                        this.firstClmIdx = n;
                    } else if (arrayList != null) {
                        arrayList.add(string);
                        arrayList2.add(n3);
                    }
                }
                ++n3;
            }
        }
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            this.table = DBTableModelUtil.newDBTable();
            n = arrayList.size();
            stringArray = arrayList.toArray(new String[n]);
            this.table.init(n);
            this.setTableDBColumn(stringArray);
            this.valueClmIdx = new int[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.valueClmIdx[i] = (Integer)arrayList2.get(i);
            }
        }
    }

    private void makeBody(RowInfo rowInfo) {
        int n;
        String[] stringArray;
        int n2 = rowInfo.rowRepeat;
        CellInfo[] cellInfoArray = rowInfo.cellInfos;
        int n3 = cellInfoArray.length;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            stringArray = cellInfoArray[i];
            for (n = 0; n < stringArray.colRepeat; ++n) {
                arrayList.add(stringArray.text);
                if (stringArray.text.length() <= 0) continue;
                bl = true;
            }
        }
        if (bl) {
            String string = (String)arrayList.get(this.firstClmIdx);
            if (string.length() > 0 && string.startsWith("#")) {
                return;
            }
            stringArray = new String[this.valueClmIdx.length];
            for (n = 0; n < this.valueClmIdx.length; ++n) {
                stringArray[n] = (String)arrayList.get(this.valueClmIdx[n]);
            }
            for (n = 0; n < n2; ++n) {
                if (this.numberOfRows < this.getMaxRowCount()) {
                    this.setTableColumnValues(stringArray);
                    ++this.numberOfRows;
                    continue;
                }
                this.table.setOverflow(true);
            }
        } else {
            return;
        }
    }

    private static final class CellInfo {
        public final int colRepeat;
        public final String text;

        CellInfo(int n, String string) {
            this.colRepeat = n;
            this.text = string;
        }
    }

    private static final class RowInfo {
        public final int rowRepeat;
        public final CellInfo[] cellInfos;

        RowInfo(int n, CellInfo[] cellInfoArray) {
            this.rowRepeat = n;
            this.cellInfos = cellInfoArray;
        }
    }

    private static class DomOdsParser {
        private static final String TABLE_TABLE_ELEM = "table:table";
        private static final String TABLE_TABLE_ROW_ELEM = "table:table-row";
        private static final String TABLE_TABLE_CELL_ELEM = "table:table-cell";
        private static final String TEXT_P_ELEM = "text:p";
        private static final String TABLE_NAME_ATTR = "table:name";
        private static final String TABLE_NUMBER_ROWS_REPEATED_ATTR = "table:number-rows-repeated";
        private static final String TABLE_NUMBER_COLUMNS_REPEATED_ATTR = "table:number-columns-repeated";
        List<RowInfo> rowInfoList = new ArrayList<RowInfo>();

        private DomOdsParser() {
        }

        public void doParse(InputStream inputStream, String string, String string2) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                this.processBook(document, string, string2);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new HybsSystemException((Throwable)parserConfigurationException);
            }
            catch (SAXException sAXException) {
                String string3 = "ODS\u30d5\u30a1\u30a4\u30eb\u4e2d\u306b\u542b\u307e\u308c\u308bcontent.xml\u304cXML\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
                throw new HybsSystemException(string3, (Throwable)sAXException);
            }
            catch (IOException iOException) {
                throw new HybsSystemException((Throwable)iOException);
            }
        }

        public List<RowInfo> getRowInfoList() {
            return this.rowInfoList;
        }

        private void processBook(Document document, String string, String string2) {
            int n;
            Object object;
            NodeList nodeList = document.getElementsByTagName(TABLE_TABLE_ELEM);
            int n2 = nodeList.getLength();
            Element[] elementArray = null;
            if (string2 != null && string2.length() > 0) {
                object = StringUtil.csv2ArrayExt((String)string2, (int)(n2 - 1));
                elementArray = new Element[((String[])object).length];
                for (n = 0; n < ((String[])object).length; ++n) {
                    elementArray[n] = (Element)nodeList.item(Integer.parseInt(object[n]));
                }
            } else if (string != null && string.length() > 0) {
                object = null;
                for (n = 0; n < n2; ++n) {
                    Element element = (Element)nodeList.item(n);
                    if (!string.equals(element.getAttribute(TABLE_NAME_ATTR))) continue;
                    object = element;
                    break;
                }
                if (object == null) {
                    String string3 = "\u5bfe\u5fdc\u3059\u308b\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 sheetName=[" + string + "]";
                    throw new HybsSystemException(string3);
                }
                elementArray = new Element[]{object};
            } else {
                object = (String[])nodeList.item(0);
                elementArray = new Element[]{object};
            }
            if (elementArray == null) {
                object = "\u5bfe\u5fdc\u3059\u308b\u30b7\u30fc\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 sheetNos=[" + string2 + "] or sheetName=[" + string + "]";
                throw new HybsSystemException((String)object);
            }
            for (int i = 0; i < elementArray.length; ++i) {
                this.processSheet(elementArray[i]);
            }
        }

        private void processSheet(Element element) {
            NodeList nodeList = element.getElementsByTagName(TABLE_TABLE_ROW_ELEM);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(TABLE_NUMBER_ROWS_REPEATED_ATTR);
                int n2 = string == null || string.length() == 0 ? 1 : Integer.parseInt(string, 10);
                this.processRow(element2, n2);
            }
        }

        private void processRow(Element element, int n) {
            NodeList nodeList = element.getElementsByTagName(TABLE_TABLE_CELL_ELEM);
            int n2 = nodeList.getLength();
            ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
            for (int i = 0; i < n2; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(TABLE_NUMBER_COLUMNS_REPEATED_ATTR);
                int n3 = string == null || string.length() == 0 ? 1 : Integer.parseInt(string, 10);
                NodeList nodeList2 = element2.getElementsByTagName(TEXT_P_ELEM);
                String string2 = nodeList2.getLength() == 0 ? "" : nodeList2.item(0).getTextContent();
                arrayList.add(new CellInfo(n3, string2));
            }
            if (!arrayList.isEmpty()) {
                this.rowInfoList.add(new RowInfo(n, arrayList.toArray(new CellInfo[arrayList.size()])));
            }
        }
    }
}

