/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.jsp.tagext.Tag;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBErrMsg;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class DirectWriteTableTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String TAB_SEPARATOR = "\t";
    private static final String errMsgId = "h_errMsg";
    private final int DB_MAX_QUERY_TIMEOUT = HybsSystem.sysInt("DB_MAX_QUERY_TIMEOUT");
    private static final String ARG_ARRAY = "ARG_ARRAY";
    private static final String ERR_MSG = "ERR_MSG";
    private static final String ERR_MSG_ARRAY = "ERR_MSG_ARRAY";
    private String dbid = null;
    private String separator = "\t";
    private boolean useHeader = true;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String zipFilename = null;
    private String sql = null;
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private boolean fileAppend = false;
    private boolean zip = false;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private long dyStart = 0L;
    private int fetchSize = 100;
    private boolean useNumber = true;
    private boolean queryType = true;
    private String names = null;
    private int errCode = 0;
    private transient ErrorMessage errMessage = null;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.length() == 0) {
            String string = "BODY \u90e8\u306e\u691c\u7d22\u7528 Select\u6587\u306f\u3001\u5fc5\u9808\u3067\u3059\u3002";
            throw new HybsSystemException(string);
        }
        this.sql = this.sql.trim();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        GUIInfo gUIInfo;
        int n;
        Object object;
        CharSequence charSequence;
        PrintWriter printWriter;
        block15: {
            this.debugPrint();
            printWriter = null;
            try {
                if (this.zip) {
                    charSequence = HybsSystem.url2dir(this.fileURL);
                    if (this.zipFilename == null) {
                        this.zipFilename = this.filename + ".zip";
                    }
                    object = null;
                    try {
                        object = new ZipOutputStream(new FileOutputStream(StringUtil.urlAppend((String)charSequence, (String)this.zipFilename)));
                        ((ZipOutputStream)object).putNextEntry(new ZipEntry(this.filename));
                        printWriter = new PrintWriter((OutputStream)object);
                        n = this.create(printWriter);
                        printWriter.flush();
                        ((ZipOutputStream)object).closeEntry();
                        ((ZipOutputStream)object).finish();
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(object);
                        throw throwable;
                    }
                    Closer.ioClose((Closeable)object);
                    break block15;
                }
                printWriter = this.getPrintWriter();
                n = this.create(printWriter);
            }
            catch (IOException iOException) {
                try {
                    String string = "Error in DirectWriteTableTag: " + this.toString();
                    throw new HybsSystemException(string, iOException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(printWriter);
                    throw throwable;
                }
            }
        }
        Closer.ioClose((Closeable)printWriter);
        this.setRequestAttribute("DB.COUNT", String.valueOf(n));
        this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
        charSequence = new StringBuilder(50);
        if (n > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
            ((StringBuilder)charSequence).append(n);
            ((StringBuilder)charSequence).append(this.getResource().getLabel(this.displayMsg));
            ((StringBuilder)charSequence).append(HybsSystem.BR);
        } else if (n == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
            ((StringBuilder)charSequence).append(this.getResource().getLabel(this.notfoundMsg));
            ((StringBuilder)charSequence).append(HybsSystem.BR);
        }
        object = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource());
        if (object != null && ((String)object).length() > 0) {
            ((StringBuilder)charSequence).append((String)object);
            this.setSessionAttribute(errMsgId, this.errMessage);
        } else {
            this.removeSessionAttribute(errMsgId);
        }
        this.jspPrint(((StringBuilder)charSequence).toString());
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        int n2 = 6;
        if (this.errCode >= 2) {
            n2 = 5;
        }
        if ((gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo")) != null) {
            gUIInfo.addReadCount(n, l, this.sql);
        }
        return n2;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = TAB_SEPARATOR;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.zipFilename = null;
        this.sql = null;
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.fileAppend = false;
        this.zip = false;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.dbid = null;
        this.fetchSize = 100;
        this.dyStart = 0L;
        this.queryType = true;
        this.names = null;
        this.errCode = 0;
        this.errMessage = null;
        this.useNumber = true;
    }

    private int create(PrintWriter printWriter) {
        int n;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        ResultSet resultSet;
        CallableStatement callableStatement;
        Statement statement;
        block20: {
            statement = null;
            callableStatement = null;
            resultSet = null;
            bl = true;
            object3 = null;
            TransactionTag transactionTag = (TransactionTag)DirectWriteTableTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object3 = transactionTag == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
            object2 = object3.getConnection(this.dbid);
            if (this.queryType) {
                statement = object2.createStatement();
                if (this.fetchSize > 0) {
                    statement.setFetchSize(this.fetchSize);
                }
                resultSet = statement.executeQuery(this.sql);
            } else {
                object = null;
                if (this.names != null) {
                    String[] stringArray = StringUtil.csv2Array((String)this.names);
                    object = this.getRequest(stringArray);
                }
                callableStatement = object2.prepareCall(this.sql);
                resultSet = this.executeCall((Connection)object2, callableStatement, (String[])object);
            }
            if (resultSet != null) break block20;
            int n2 = 0;
            Closer.resultClose((ResultSet)resultSet);
            Closer.stmtClose((Statement)statement);
            Closer.stmtClose((Statement)callableStatement);
            if (object3 != null) {
                object3.close(bl);
            }
            return n2;
        }
        try {
            Object object4;
            Object object5;
            object = resultSet.getMetaData();
            int n3 = object.getColumnCount();
            if (this.useHeader && n3 > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                object5 = new StringBuilder();
                stringBuilder.append("#Name");
                ((StringBuilder)object5).append("#Label");
                object4 = this.getResource();
                for (int i = 1; i <= n3; ++i) {
                    String string = object.getColumnLabel(i).toUpperCase(Locale.JAPAN);
                    stringBuilder.append(TAB_SEPARATOR).append(string);
                    ((StringBuilder)object5).append(TAB_SEPARATOR).append(((ResourceManager)object4).getLabel(string));
                }
                printWriter.println(stringBuilder.toString());
                printWriter.println(((StringBuilder)object5).toString());
            }
            int n4 = 0;
            while (resultSet.next()) {
                if (this.useNumber) {
                    printWriter.print(n4);
                }
                for (int i = 1; i <= n3; ++i) {
                    if (i != 1 || this.useNumber || this.useHeader) {
                        printWriter.print(this.separator);
                    }
                    object5 = resultSet.getObject(i);
                    if (object5 == null) continue;
                    object4 = object5.toString();
                    if (((String)object4).indexOf(34) >= 0) {
                        object4 = ((String)object4).replaceAll("\"", "\"\"");
                    }
                    if (((String)object4).indexOf(HybsSystem.CR) >= 0) {
                        object4 = "\"" + (String)object4 + "\"";
                    }
                    printWriter.print((String)object4);
                }
                printWriter.println();
                ++n4;
            }
            n = n4;
            bl = false;
        }
        catch (SQLException sQLException) {
            try {
                object2 = "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u51e6\u7406\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsSystem.CR + statement + HybsSystem.CR + "err=[" + sQLException.getSQLState() + "]" + sQLException.getMessage();
                throw new HybsSystemException((String)object2, sQLException);
            }
            catch (Throwable throwable) {
                Closer.resultClose(resultSet);
                Closer.stmtClose(statement);
                Closer.stmtClose(callableStatement);
                if (object3 != null) {
                    object3.close(bl);
                }
                throw throwable;
            }
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
        Closer.stmtClose((Statement)callableStatement);
        if (object3 != null) {
            object3.close(bl);
        }
        return n;
    }

    private ResultSet executeCall(Connection connection, CallableStatement callableStatement, String[] stringArray) throws SQLException {
        ResultSet resultSet = null;
        callableStatement.setQueryTimeout(this.DB_MAX_QUERY_TIMEOUT);
        if (this.fetchSize > 0) {
            callableStatement.setFetchSize(this.fetchSize);
        }
        Map<String, Class<?>> map = connection.getTypeMap();
        try {
            map.put(ERR_MSG, Class.forName("org.opengion.hayabusa.db.DBErrMsg"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "org.opengion.hayabusa.db.DBErrMsg \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + HybsSystem.CR + classNotFoundException.getMessage();
            throw new HybsSystemException(string, classNotFoundException);
        }
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)ARG_ARRAY, (Connection)connection);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)StringUtil.rTrims((String[])stringArray));
        callableStatement.registerOutParameter(1, 4);
        callableStatement.registerOutParameter(2, 2003, ERR_MSG_ARRAY);
        callableStatement.registerOutParameter(3, -10);
        ((OracleCallableStatement)callableStatement).setARRAY(4, aRRAY);
        callableStatement.execute();
        this.errCode = callableStatement.getInt(1);
        if (this.errCode < 2) {
            resultSet = ((OracleCallableStatement)callableStatement).getCursor(3);
        }
        if (this.errCode > 0) {
            DBErrMsg dBErrMsg;
            ARRAY aRRAY2 = ((OracleCallableStatement)callableStatement).getARRAY(2);
            Object[] objectArray = (Object[])aRRAY2.getArray();
            this.errMessage = new ErrorMessage("Query_JDBCErrMsg Error!!");
            for (int i = 0; i < objectArray.length && (dBErrMsg = (DBErrMsg)objectArray[i]) != null; ++i) {
                this.errMessage.addMessage(dBErrMsg.getErrMsg());
            }
        }
        return resultSet;
    }

    private PrintWriter getPrintWriter() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        String string = HybsSystem.url2dir(this.fileURL);
        return FileUtil.getPrintWriter((File)new File(string, this.filename), (String)this.encode, (boolean)this.fileAppend);
    }

    private String[] getRequest(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.getRequestValue(stringArray[i]);
        }
        return stringArray2;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)TAB_SEPARATOR);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setZipFilename(String string) {
        this.zipFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.zipFilename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setUseHeader(String string) {
        this.useHeader = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useHeader);
    }

    public void setFileAppend(String string) {
        this.fileAppend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fileAppend);
    }

    public void setZip(String string) {
        this.zip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.zip);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setFetchSize(String string) {
        this.fetchSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.fetchSize);
    }

    public void setNames(String string) {
        this.names = StringUtil.nval((String)this.getRequestParameter(string), (String)this.names);
    }

    public void setQueryType(String string) {
        this.queryType = !"JDBCErrMsg".equalsIgnoreCase(this.getRequestParameter(string));
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("separator", (Object)this.separator).println("useHeader", (Object)this.useHeader).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("zipFilename", (Object)this.zipFilename).println("sql", (Object)this.sql).println("encode", (Object)this.encode).println("fileAppend", (Object)this.fileAppend).println("zip", (Object)this.zip).println("displayMsg", (Object)this.displayMsg).println("dyStart", (Object)this.dyStart).println("fetchSize", (Object)this.fetchSize).println("queryType", (Object)this.queryType).println("names", (Object)this.names).println("errCode", (Object)this.errCode).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

