/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_ImageTimeBar
extends ViewForm_HTMLTable {
    private static final String VERSION = "5.5.5.6 (2012/08/31)";
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color NULL_COLOR = Color.WHITE;
    private long startDate;
    private long timeSpan;
    private boolean useLegend;
    private int maxLabelWidth;
    private int maxTimeWidth;
    private int chartHeight;
    private int chartPadding;
    private int recodeMargin;
    private boolean useLastData;
    private String tempDir;
    private String tempUrl;
    private static final int keyClmNo = 0;
    private static final int dyClmNo = 1;
    private static final int fgjClmNo = 2;
    private int[] labelClmsNo = null;
    private int[] maxClmWidth = null;
    private int colClmNo = -1;
    private int tipsClmNo = -1;
    private int linkClmNo = -1;
    private int str2DateTime;
    private int startTime;
    private int MAX_X;
    private int MAX_Y;
    private static final Stroke DSAH_STROK = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);

    @Override
    public String create(int n, int n2) {
        Object object;
        if (this.getRowCount() == 0) {
            return "";
        }
        this.paramInit();
        int n3 = this.getLastNo(n, n2);
        this.calcImageSize(n, n3);
        BufferedImage bufferedImage = new BufferedImage(this.MAX_X, this.MAX_Y, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(this.chartPadding, this.chartPadding, this.MAX_X - this.chartPadding * 2 + 1, this.MAX_Y - this.chartPadding * 2 + 1);
        StringBuilder stringBuilder = new StringBuilder(500);
        String string = "";
        long l = 0L;
        Color color = NULL_COLOR;
        ColorMap colorMap = new ColorMap();
        int n4 = this.useLegend ? 2 : 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.chartHeight;
        int n9 = this.chartHeight + this.recodeMargin * 2;
        double d = (double)this.maxTimeWidth / (double)this.timeSpan;
        boolean bl = this.tipsClmNo >= 0 || this.linkClmNo >= 0;
        for (int i = n; i < n3; ++i) {
            long l2;
            object = this.getValue(i, 0);
            String string2 = this.getValue(i, 1);
            if (!string.equals(object)) {
                if (i > n) {
                    n5 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
                    n7 = (int)((double)(this.timeSpan - l) * d);
                    if (n7 > 0) {
                        if (this.useLastData) {
                            graphics2D.setColor(color);
                        } else {
                            graphics2D.setColor(NULL_COLOR);
                        }
                        graphics2D.fillRect(n5, n6 + this.recodeMargin, n7, n8);
                        if (this.useLastData && bl && i > 0) {
                            String string3;
                            String string4 = this.tipsClmNo >= 0 ? this.getValueLabel(i - 1, this.tipsClmNo) : this.getValueLabel(i - 1, 2);
                            stringBuilder.append("<area shape='rect' alt='").append(string4).append("'");
                            if (this.linkClmNo >= 0 && (string3 = this.getValueLabel(i - 1, this.linkClmNo)) != null && string3.startsWith("href")) {
                                stringBuilder.append(string3);
                            }
                            stringBuilder.append(" coords='").append(n5).append(",").append(n6 + this.recodeMargin).append(",");
                            stringBuilder.append(n5 + n7).append(",").append(n6 + this.recodeMargin + this.chartHeight).append("' />");
                        }
                    }
                }
                string = object;
                n6 = this.chartPadding + n9 * n4;
                ++n4;
                int n10 = this.labelClmsNo.length;
                int n11 = this.chartPadding;
                int n12 = n6 + this.chartHeight + this.recodeMargin;
                graphics2D.setColor(LABEL_COLOR);
                for (int j = 0; j < n10; ++j) {
                    String string5 = this.getValueLabel(i, this.labelClmsNo[j]);
                    graphics2D.drawString(string5, n11 + this.recodeMargin, n12);
                    n11 += this.recodeMargin * 2 + this.maxClmWidth[j];
                }
                graphics2D.drawRect(this.chartPadding, n6, this.MAX_X - this.chartPadding * 2, n9);
                l = 0L;
                color = NULL_COLOR;
            }
            if ((l2 = this.getStr2Date(string2) - this.startDate) < l) {
                l2 = l;
            }
            n5 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            n7 = (int)((double)(l2 - l) * d);
            if (n7 > 0) {
                graphics2D.setColor(color);
                graphics2D.fillRect(n5, n6 + this.recodeMargin, n7, this.chartHeight);
                if (bl && i > 0) {
                    String string6;
                    String string7 = this.tipsClmNo >= 0 ? this.getValueLabel(i - 1, this.tipsClmNo) : this.getValueLabel(i - 1, 2);
                    stringBuilder.append("<area shape='rect' alt='").append(string7).append("'");
                    if (this.linkClmNo >= 0 && (string6 = this.getValueLabel(i - 1, this.linkClmNo)) != null && string6.startsWith("href")) {
                        stringBuilder.append(string6);
                    }
                    stringBuilder.append(" coords='").append(n5).append(",").append(n6 + this.recodeMargin).append(",");
                    stringBuilder.append(n5 + n7).append(",").append(n6 + this.recodeMargin + this.chartHeight).append("' />");
                }
            }
            l = l2;
            String string8 = this.getValue(i, 2);
            String string9 = this.getValueLabel(i, 2);
            color = this.colClmNo >= 0 ? colorMap.getColor(string8, string9, this.getValue(i, this.colClmNo)) : colorMap.getColor(string8, string9);
        }
        if (l < this.timeSpan) {
            n5 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            n7 = (int)((double)(this.timeSpan - l) * d);
            if (this.useLastData) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(NULL_COLOR);
            }
            graphics2D.fillRect(n5, n6 + this.recodeMargin, n7, this.chartHeight);
            if (this.useLastData && bl) {
                String string10 = this.tipsClmNo >= 0 ? this.getValueLabel(n3 - 1, this.tipsClmNo) : this.getValueLabel(n3 - 1, 2);
                stringBuilder.append("<area shape='rect' alt='").append(string10).append("'");
                if (this.linkClmNo >= 0 && (object = this.getValueLabel(n3 - 1, this.linkClmNo)) != null && ((String)object).startsWith("href")) {
                    stringBuilder.append((String)object);
                }
                stringBuilder.append(" coords='").append(n5).append(",").append(n6 + this.recodeMargin).append(",");
                stringBuilder.append(n5 + n7).append(",").append(n6 + this.recodeMargin + this.chartHeight).append("' />");
            }
        }
        this.imageHeaderPaint(graphics2D, d, colorMap);
        File file = null;
        try {
            object = new File(this.tempDir);
            ((File)object).mkdirs();
            file = File.createTempFile("Img", ".png", (File)object);
            file.deleteOnExit();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
            graphics2D.dispose();
        }
        catch (IOException iOException) {
            System.out.println("\u30a8\u30e9\u30fc:" + iOException);
        }
        int n13 = this.MAX_X;
        int n14 = this.MAX_Y;
        StringBuilder stringBuilder2 = new StringBuilder(500);
        stringBuilder2.append("<img id='ImageTimeBar' alt='ImageTimeBar' border='0'");
        stringBuilder2.append(" width='").append(n13).append("px' height='").append(n14).append("px'");
        stringBuilder2.append(" src='").append(this.tempUrl).append(file.getName()).append("'");
        if (stringBuilder.length() > 0) {
            stringBuilder2.append(" usemap='#TimeBarMap' />");
            stringBuilder2.append("<map name='TimeBarMap'>");
            stringBuilder2.append((CharSequence)stringBuilder);
            stringBuilder2.append("</map>");
        } else {
            stringBuilder2.append(" />");
        }
        return stringBuilder2.toString();
    }

    private void paramInit() {
        String string = this.getParam("START_DATE");
        int n = this.getIntParam("TIME_SPAN");
        String[] stringArray = StringUtil.csv2Array((String)this.getParam("LABEL_CLMS"));
        String string2 = this.getParam("COLOR_CLM");
        String string3 = this.getParam("TIPS_CLM");
        String string4 = this.getParam("LINK_CLM");
        this.useLegend = this.getBoolParam("USE_LEGEND");
        this.maxLabelWidth = this.getIntParam("MAX_LABEL_WIDTH");
        this.maxTimeWidth = this.getIntParam("MAX_TIME_WIDTH");
        this.chartHeight = this.getIntParam("CHART_HEIGHT");
        this.chartPadding = this.getIntParam("CHART_PADDING");
        this.recodeMargin = this.getIntParam("RECODE_MARGIN");
        this.useLastData = this.getBoolParam("USE_LAST_DATA");
        this.tempDir = this.getParam("TEMP_DIR");
        this.tempUrl = this.getParam("TEMP_URL");
        this.startDate = this.getStr2Date(string);
        this.startTime = this.str2DateTime;
        this.timeSpan = (long)n * 60L;
        int n2 = stringArray.length;
        if (n2 > 0) {
            this.labelClmsNo = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.labelClmsNo[i] = this.getColumnNo(stringArray[i]);
            }
        } else {
            this.labelClmsNo = new int[]{0};
        }
        if (string2 != null) {
            this.colClmNo = this.getColumnNo(string2);
        }
        if (string3 != null) {
            this.tipsClmNo = this.getColumnNo(string3);
        }
        if (string4 != null) {
            this.linkClmNo = this.getColumnNo(string4);
        }
    }

    private void calcImageSize(int n, int n2) {
        int n3;
        String string = "";
        int n4 = this.labelClmsNo.length;
        this.maxClmWidth = new int[n4];
        int n5 = n3 = this.useLegend ? 2 : 1;
        if (this.maxLabelWidth < 0) {
            String string2;
            int n6;
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n6 = 0; n6 < n4; ++n6) {
                string2 = this.getColumnLabel(this.labelClmsNo[n6]);
                this.maxClmWidth[n6] = fontMetrics.stringWidth(string2);
            }
            for (n6 = n; n6 < n2; ++n6) {
                string2 = this.getValue(n6, 0);
                if (string.equals(string2)) continue;
                string = string2;
                ++n3;
                for (int i = 0; i < n4; ++i) {
                    String string3 = this.getValueLabel(n6, this.labelClmsNo[i]);
                    int n7 = fontMetrics.stringWidth(string3);
                    if (this.maxClmWidth[i] >= n7) continue;
                    this.maxClmWidth[i] = n7;
                }
            }
            graphics2D.dispose();
            this.maxLabelWidth = this.recodeMargin * 2 * n4;
            for (n6 = 0; n6 < n4; ++n6) {
                this.maxLabelWidth += this.maxClmWidth[n6];
            }
        } else {
            int n8;
            for (n8 = n; n8 < n2; ++n8) {
                String string4 = this.getValue(n8, 0);
                if (string.equals(string4)) continue;
                string = string4;
                ++n3;
            }
            n8 = (this.maxLabelWidth - this.recodeMargin * 2 * n4) / n4;
            for (int i = 0; i < n4; ++i) {
                this.maxClmWidth[i] = n8;
            }
        }
        this.MAX_X = this.chartPadding * 2 + this.maxLabelWidth + this.maxTimeWidth;
        this.MAX_Y = this.chartPadding * 2 + (this.chartHeight + this.recodeMargin * 2) * n3;
    }

    private void imageHeaderPaint(Graphics2D graphics2D, double d, ColorMap colorMap) {
        int n;
        int n2;
        int n3;
        int n4 = this.chartPadding;
        int n5 = this.chartPadding + this.chartHeight + this.recodeMargin;
        if (this.useLegend && colorMap != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n3 = fontMetrics.stringWidth(colorMap.getMaxLengthLabel());
            n2 = this.chartHeight;
            n = this.recodeMargin;
            int n6 = n3 + this.recodeMargin;
            int n7 = this.chartPadding;
            for (Object[] objectArray : colorMap.values()) {
                String string = (String)objectArray[0];
                Color color = (Color)objectArray[1];
                graphics2D.setColor(color);
                graphics2D.fillRect(n7, n4 + this.recodeMargin, n2, this.chartHeight);
                graphics2D.setColor(LABEL_COLOR);
                graphics2D.drawString(string, n7 += n2 + n, n5);
                n7 += n6;
            }
            n4 += this.chartHeight + this.recodeMargin * 2;
            n5 += this.chartHeight + this.recodeMargin * 2;
        }
        graphics2D.setColor(LABEL_COLOR);
        graphics2D.drawRect(this.chartPadding, n4, this.MAX_X - this.chartPadding * 2, this.MAX_Y - n4 - this.chartPadding);
        int n8 = this.labelClmsNo.length;
        n3 = this.chartPadding;
        for (n2 = 0; n2 < n8; ++n2) {
            String string = this.getColumnLabel(this.labelClmsNo[n2]);
            graphics2D.drawString(string, n3 + this.recodeMargin, n5);
            graphics2D.drawLine(n3 += this.recodeMargin * 2 + this.maxClmWidth[n2], n4, n3, this.MAX_Y - this.chartPadding);
        }
        n2 = TimeScaleStep.getStep(d);
        graphics2D.setStroke(DSAH_STROK);
        n3 = this.chartPadding + this.maxLabelWidth;
        n = 0;
        while ((long)n < this.timeSpan) {
            graphics2D.drawString(this.getTime2Str(this.startTime + n, n2), n3 + this.recodeMargin, n5);
            graphics2D.drawLine(n3, n4, n3, this.MAX_Y - this.chartPadding);
            n3 += (int)((double)n2 * d);
            n += n2;
        }
    }

    private int getStr2Time(String string, int n) {
        if (string == null || string.isEmpty()) {
            return n;
        }
        int n2 = 0;
        switch (string.length()) {
            case 1: 
            case 2: {
                n2 = Integer.parseInt(string);
                break;
            }
            case 3: {
                n2 = Integer.parseInt(string.substring(0, 1)) * 60 + Integer.parseInt(string.substring(1, 3));
                break;
            }
            default: {
                n2 = Integer.parseInt(string.substring(0, 2)) * 60 + Integer.parseInt(string.substring(2, 4));
            }
        }
        return n2;
    }

    private long getStr2Date(String string) {
        Calendar calendar = Calendar.getInstance();
        this.str2DateTime = 0;
        if (string == null) {
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
        } else if (string.length() == 8) {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
        } else {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)));
            this.str2DateTime = Integer.parseInt(string.substring(8, 10)) * 60 + Integer.parseInt(string.substring(10, 12));
        }
        return calendar.getTimeInMillis() / 60000L;
    }

    private String getTime2Str(int n, int n2) {
        int n3 = n / 60 / 24;
        int n4 = n / 60 % 24;
        int n5 = n % 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 >= 1440) {
            stringBuilder.append(n3).append("d");
        } else {
            if (n4 < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n4);
            if (n2 < 60) {
                stringBuilder.append(":");
                if (n5 < 10) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(n5);
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEditable() {
        return false;
    }

    private static final class ColorMap {
        private static final Color[] CLR_ARY = new Color[]{Color.BLUE, Color.CYAN, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.DARK_GRAY, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
        private int lastCnt = 0;
        private final Map<String, Object[]> colMap = new TreeMap<String, Object[]>();
        private String maxLabel = "";
        private int maxlen = -1;

        private ColorMap() {
        }

        public Color getColor(String string, String string2) {
            return this.getColor(string, string2, null);
        }

        public Color getColor(String string, String string2, String string3) {
            Object[] objectArray;
            int n;
            if (string == null) {
                return LABEL_COLOR;
            }
            if (string2 != null && (n = string2.length()) > this.maxlen) {
                this.maxLabel = string2;
                this.maxlen = n;
            }
            if ((objectArray = this.colMap.get(string)) == null) {
                objectArray = new Object[]{string2, string3 != null ? StringUtil.getColorInstance((String)string3) : this.uniqColor()};
                this.colMap.put(string, objectArray);
            }
            return (Color)objectArray[1];
        }

        public Color uniqColor() {
            Color color = null;
            if (this.lastCnt < CLR_ARY.length) {
                color = CLR_ARY[this.lastCnt++];
            } else {
                int n = (int)(Math.random() * 256.0);
                int n2 = (int)(Math.random() * 256.0);
                int n3 = (int)(Math.random() * 256.0);
                color = new Color(n, n2, n3);
            }
            return color;
        }

        public Collection<Object[]> values() {
            return this.colMap.values();
        }

        public String getMaxLengthLabel() {
            return this.maxLabel;
        }
    }

    private static final class TimeScaleStep {
        private static final int[] STEPS = new int[]{10, 30, 60, 360, 720, 1440};
        private static final int MIN_PX = 25;

        private TimeScaleStep() {
        }

        public static final int getStep(double d) {
            int n = (int)Math.ceil(25.0 / d);
            for (int i = 0; i < STEPS.length; ++i) {
                if (n > STEPS[i]) continue;
                return STEPS[i];
            }
            return (int)Math.ceil(n / STEPS[STEPS.length - 1]) * STEPS[STEPS.length - 1];
        }
    }
}

