/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.TagBuffer;

/**
 * MENU エディターは、カラムのデータをコードリソースに対応した
 * プルダウンメニューで編集する場合に使用するクラスです。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ編集
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_MENU extends AbstractEditor {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	// 3.2.3.0 (2003/06/06) final を削除。サブクラスからアクセスできるように変更。
	/** セレクションオブジェクト */
	protected Selection	selection ;
	private final boolean addNoValue ;		// 3.5.5.7 (2004/05/10)
	/** シーケンスフラグ */
	protected boolean seqFlag ;			// 3.6.0.6 (2004/10/22)
	private final String useSlabel ;	// 5.5.1.0 (2012/04/03)

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.6.0.6 (2004/10/22) シーケンスアクセス機能(seqFlag)を追加します
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 *
	 */
	public Editor_MENU() {
		// 4.3.4.4 (2009/01/01)
//		super();
		selection = null;
		addNoValue = false;		// 3.5.5.7 (2004/05/10)
		seqFlag    = false;		// 3.6.0.6 (2004/10/22)
		useSlabel = "auto";		// 5.5.1.0 (2012/04/03)
	}

	/**
	 * コンストラクター。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.3.1.1 (2003/07/03) name , attributes 属性を final にする。
	 * @og.rev 3.5.4.2 (2003/12/15) makeCodeSelection メソッドを CodeSelectionクラスに変更。
	 * @og.rev 3.5.5.7 (2004/05/10) SelectionFactory を使用して、オブジェクト作成
	 * @og.rev 3.5.5.7 (2004/05/10) addNoValue 属性を追加します。
	 * @og.rev 3.5.6.0 (2004/06/18) XHTMLTag の 内部配列 SELECT_KEY を隠蔽します。
	 * @og.rev 3.6.0.6 (2004/10/22) シーケンスアクセス機能(seqFlag)を追加します
	 * @og.rev 4.0.0 (2005/01/31) Selection_CODE の作成の引数を CodeData に変更。
	 * @og.rev 4.0.0.0 (2007/11/07) SelectionオブジェクトをDBColumnから取得
	 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
	 * @og.rev 5.5.1.0 (2012/04/03) Slabel対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	protected Editor_MENU( final DBColumn clm ) {
	//	super( clm );
		name  = clm.getName();
		addNoValue = clm.isAddNoValue() ;		// 3.5.5.7 (2004/05/10)
		seqFlag    = "SEQ".equals( clm.getEditorParam() );	// 3.6.0.6 (2004/10/22)
//		eventColumn = clm.getEventColumn(); // 4.3.6.0 (2009/04/01)
//		eventURL	= clm.getEventURL();	// 4.3.6.0 (2009/04/01)
//		editor		= clm.getEditor();		// 4.3.6.0 (2009/04/01)
		useSlabel = clm.getUseSlabel() ;	// 5.5.1.0 (2012/04/03)

		String	disabled = clm.isWritable() ? null : "disabled" ;

		attributes = new Attributes();
		attributes.set( "disabled"	,disabled );

		attributes.addAttributes( clm.getEditorAttributes() );
		optAttr = attributes.get( "optionAttributes" );
		tagBuffer.add( XHTMLTag.selectAttri( attributes ) );

		selection = clm.getSelection();	// 4.0.0 (2005/01/31)
		// 5.6.1.1 (2013/02/08) 暫定処置
		if( selection != null ) {
			boolean useMultiSelect = selection.useMultiSelect();
			if( useMultiSelect ) { tagBuffer.add( "onkeydown" , "setKeySelect(this);" ); }
		}
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 * @og.rev 3.1.2.1 (2003/04/10) synchronized を、削除します。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_MENU( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @og.rev 3.5.5.5 (2004/04/23) 新規に Attributes オブジェクトを作成する方式を止めます。
	 * @og.rev 3.5.5.7 (2004/05/10) addNoValue 属性を追加します。
	 * @og.rev 3.6.0.6 (2004/10/22) シーケンスアクセス機能(seqFlag)を追加します
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 * @og.rev 5.1.3.0 (2010/02/01) 一覧表示のみで、ツールチップ表示を行う。
	 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
	 * @og.rev 5.5.1.0 (2012/04/03) useSlabel対応
	 *
	 * @param	value 入力値
	 *
	 * @return	データの編集用文字列
	 */
	@Override
	public String getValue( final String value ) {
//		final boolean uslbl = !"true".equals(useSlabel) ? false : true; // 5.5.1.0 (2012/04/03)
		final boolean uslbl = "true".equalsIgnoreCase( useSlabel );		// 5.5.1.0 (2012/04/03)

		TagBuffer tag = new TagBuffer( "select" );
		tag.add( "name"    , name );
		tag.add( tagBuffer.makeTag() );
		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)
		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
			tag.add( "id"    , name ); // 4.3.6.0 (2009/04/01)
		}

		if( addNoValue ) {
			// 5.1.3.0 (2010/02/01)
//			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag ) );
//			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag,false ) );
			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag,uslbl ) ); // 5.5.1.0 (2012/04/03)
		}
		else {
			// 5.1.3.0 (2010/02/01)
//			tag.setBody( selection.getOption( value,seqFlag ) );
			// tag.setBody( selection.getOption( value,seqFlag,false ) );
			tag.setBody( selection.getOption( value,seqFlag,uslbl ) ); // 5.5.1.0 (2012/04/03)
		}

		return tag.makeTag();
//		return tag.makeTag() + createEventColumnJS( name, editor, -1, eventURL ); // 4.3.6.0 (2009/04/01)
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 2.0.0.3 (2002/09/26) optionAttributes 属性に "$i" を使うとその行数に置き換る機能を追加。
	 * @og.rev 3.1.0.0 (2003/03/20) 名前と行番号の区切り記号を "^" から "__" に変更。
	 * @og.rev 3.5.5.0 (2004/03/12) 名前と行番号の区切り記号("__")を、HybsSystem.JOINT_STRING  に変更。
	 * @og.rev 3.5.5.5 (2004/04/23) 新規に Attributes オブジェクトを作成する方式を止めます。
	 * @og.rev 3.5.5.7 (2004/05/10) addNoValue 属性を追加します。
	 * @og.rev 3.6.0.6 (2004/10/22) シーケンスアクセス機能(seqFlag)を追加します
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 * @og.rev 5.1.3.0 (2010/02/01) 一覧表示のみで、ツールチップ表示を行う。
	 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
	 * @og.rev 5.5.1.0 (2012/04/03) useSlabel対応
	 *
	 * @param	row   行番号
	 * @param	value 入力値
	 *
	 * @return	データ表示/編集用の文字列
	 */
	@Override
	public String getValue( final int row,final String value ) {
//		final boolean uslbl = ("auto".equals(useSlabel) || "true".equals(useSlabel) ) ? true : false; // 5.5.1.0 (2012/04/03)
		final boolean uslbl = "auto".equalsIgnoreCase( useSlabel ) || "true".equalsIgnoreCase( useSlabel );		 // 5.5.1.0 (2012/04/03)

		TagBuffer tag = new TagBuffer( "select" );
		String newName = name + HybsSystem.JOINT_STRING + row; // 4.3.6.0 (2009/04/01)
		// tag.add( "name"    , name + HybsSystem.JOINT_STRING + row );
		tag.add( "name", newName ); // 4.3.6.0 (2009/04/01)
		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
			tag.add( "id"  , newName ); // 4.3.6.0 (2009/04/01)
		}
		tag.add( tagBuffer.makeTag() );
		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)

		if( addNoValue ) {
			// 5.1.3.0 (2010/02/01)
//			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag ) );
//			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag,true ) );
			tag.setBody( Selection.NO_VALUE_OPTION + selection.getOption( value,seqFlag,uslbl ) ); // 5.5.1.0 (2012/04/03)
		}
		else {
			// 5.1.3.0 (2010/02/01)
//			tag.setBody( selection.getOption( value,seqFlag ) );
//			tag.setBody( selection.getOption( value,seqFlag,true ) );
			tag.setBody( selection.getOption( value,seqFlag,uslbl ) ); // 5.5.1.0 (2012/04/03)
		}

		return tag.makeTag( row,value );
//		return tag.makeTag( row,value ) + createEventColumnJS( name, editor, row, eventURL ); // 4.3.6.0 (2009/04/01)
	}
}
