/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.Selection_NUM;

/**
 * カラムの編集パラメーターの開始、終了、ステップの情報より、プルダウンメニューを作成して
 * 編集する場合に使用するエディタークラスです。
 *
 * ここでは、数字（連番）の自動生成を行います。パラメータで、開始、終了、ステップを指定します。
 * パラメータの初期値は、開始(1)、終了(10)、ステップ(1) です。
 * 
 * 例：1,10,1    → 1,2,3,4,5,6,7,8,9,10 のプルダウン
 * 例：10,100,10 → 10,20,30,40,50,60,70,80,90,100 のプルダウン
 * 例：-5,5,1    → -5,-4,-3,-2,-1,0,1,2,3,4,5 のプルダウン
 * 例：5,-5,-2   → 5,3,1,-1,-3,-5 のプルダウン
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 5.6.1.1 (2013/02/08) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_NUMMENU extends Editor_MENU {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.6.1.1 (2013/02/08)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_NUMMENU() {
		super();
	}

	/**
	 * コンストラクター。
	 * ここでは、親クラスの Editor_MENU で初期化を行い、セレクションオブジェクト に、
	 * Selection_NUM を使用するように再設定します。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_NUMMENU( final DBColumn clm ) {
		super( clm );

		selection = new Selection_NUM( clm.getEditorParam() );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_NUMMENU( clm );
	}
}
