/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import java.util.Arrays;

import org.opengion.fukurou.util.StringUtil;

/**
 * 固定長ファイルの読み取りクラスです。
 *
 * NAMEは、先頭に、#NAME とすることで自動的にカラム名に対応付けます。
 * 外部から、指定することも出来ます。(外部指定が優先)
 * 固定長での読み取りでは、各行の先頭の行番号は、含めないで下さい。先頭より、
 * データを埋めてください。
 *
 * @og.rev 3.5.4.5 (2004/01/23) 新規作成
 * @og.group ファイル入力
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class TableReader_Fixed extends TableReader_Default {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	/**
	 * BufferedReader より読み込んだ１行のデータをテーブルモデルにセットするように分割します
	 * なお、読込みは，NAME項目分を読み込みます。データ件数が少ない場合は、
	 * "" をセットしておきます。
	 *
	 * @og.rev 3.5.5.5 (2004/04/23) DBColumn の size と maxlength の 意味を変更
	 *
	 * @param	data	１行のデータ
	 * @param	clmSize	カラムサイズ
	 *
	 * @return	１行のデータ分の配列
	 */
	@Override
	protected String[] readData( final String data,final int clmSize ) {
		String[] rtnData = new String[ clmSize ];
		String encode = getEncode();

		byte[] dt = StringUtil.makeByte( data,encode );
		int dtSize = dt.length ;

		int startPos = 0;
		int clmNo    = 0;

		for( ; clmNo < clmSize; clmNo++ ) {
			int size = dbColumn[clmNo].getTotalSize() ;		// 4.0.0 (2005/01/31) メソッド名変更
			int endPos = startPos + size ;

			// データ不足の判定。
			// 残りのカラムは、ゼロストリングをセットしておきます。
			if( dtSize < endPos ) {
				Arrays.fill( rtnData,clmNo,clmSize,"" );
				break;
			}

			String val = StringUtil.makeString( dt,startPos,size,encode );
			val = dbColumn[clmNo].valueSet( val );
			if( val == null ) { val = ""; }

			rtnData[clmNo] = val;
			startPos = endPos;
		}

		return rtnData;
	}
}
