/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;
import java.util.List;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_JSON
extends TableWriter_Default {
    private static final String VERSION = "5.6.0.3 (2012/01/24)";
    private String jsonName = null;
    private boolean toLowerCase = false;

    @Override
    public void writeDBTable(PrintWriter printWriter) {
        super.setHeaderSequence("D");
        super.writeDBTable(printWriter);
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n;
        int n2 = dBTableModel.getRowCount();
        String[] stringArray = dBTableModel.getNames();
        if (this.toLowerCase) {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].toLowerCase();
            }
        }
        if (this.jsonName != null) {
            printWriter.println("{");
            printWriter.print("\"");
            printWriter.print(this.jsonName);
            printWriter.print("\":");
        }
        printWriter.println("[");
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                printWriter.print(",");
            }
            printWriter.print("{");
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int n3 = this.clmNo[i];
                String string = (String)dBTableModel.getValue(n, n3);
                if (string.contains("\\") || string.contains("\"")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int j = 0; j < string.length(); ++j) {
                        char c = string.charAt(j);
                        if (c == '\\' || c == '\"') {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                    }
                    string = stringBuilder.toString();
                }
                if (i > 0) {
                    printWriter.print(",");
                }
                printWriter.print('\"');
                printWriter.print(stringArray[n3]);
                printWriter.print("\":\"");
                printWriter.print(string);
                printWriter.print('\"');
            }
            printWriter.println("}");
        }
        printWriter.println("]");
        if (this.jsonName != null) {
            printWriter.println("}");
        }
    }

    public void setParam(List<HybsEntry> list) {
        if (list != null && !list.isEmpty()) {
            for (HybsEntry hybsEntry : list) {
                if ("JsonName".equalsIgnoreCase(hybsEntry.getKey())) {
                    this.jsonName = hybsEntry.getValue();
                }
                if (!"LowerCase".equalsIgnoreCase(hybsEntry.getKey())) continue;
                this.toLowerCase = true;
            }
        }
    }
}

