/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.io.File;
import java.io.PrintWriter;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.FixLengthData;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;

public class TableFilter_SEQUENCE
extends AbstractTableFilter {
    private static final String VERSION = "5.6.6.0 (2013/07/05)";
    private static final String[] DBKEY;
    protected static final int SYSTEM_ID = 0;
    protected static final int TBLSYU = 1;
    protected static final int SEQNAME = 2;
    protected static final int INCREBY = 3;
    protected static final int STARTVAL = 4;
    protected static final int MINVAL = 5;
    protected static final int MAXVAL = 6;
    protected static final int FGCYCLE = 7;
    protected static final int SUCACHE = 8;
    private static final String ENCODE = "UTF-8";
    private static final String CMNT = "************************************************************************";
    private static final int X = 0;
    private static final int K = 2;
    protected static final String XML_START_TAG;
    protected static final String XML_END_TAG = "</ROWSET>";
    protected static final String EXEC_START_TAG = "<EXEC_SQL>";
    protected static final String EXEC_END_TAG = "</EXEC_SQL>";
    protected boolean isXml = false;

    public DBTableModel execute() {
        DBTableModel dBTableModel = this.getDBTableModel();
        this.isXml = StringUtil.nval((String)this.getValue("XML"), (boolean)false);
        int[] nArray = this.getTableColumnNo(DBKEY);
        int n = dBTableModel.getRowCount();
        File file = new File(this.getValue("DIR"));
        if (!file.exists() && !file.mkdirs()) {
            String string = "\u6240\u5b9a\u306e\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file + "]";
            throw new HybsSystemException(string);
        }
        String[] stringArray = null;
        PrintWriter printWriter = null;
        for (int i = 0; i < n; ++i) {
            stringArray = (String[])dBTableModel.getValues(i);
            String string = stringArray[nArray[2]];
            try {
                printWriter = FileUtil.getPrintWriter((File)new File(file, string + (this.isXml ? ".xml" : ".sql")), (String)ENCODE);
                if (this.isXml) {
                    printWriter.println(XML_START_TAG);
                }
                printWriter.println(this.makeHeadLine(nArray, stringArray));
                printWriter.println(this.makeLineList(nArray, stringArray));
            }
            catch (RuntimeException runtimeException) {
                ErrorMessage errorMessage = this.makeErrorMessage("TableFilter_SEQNENCE Error", 2);
                errorMessage.addMessage(i + 1, 2, "SEQUENCE", new String[]{runtimeException.getMessage()});
                errorMessage.addMessage(i + 1, 2, "SEQUENCE", new String[]{StringUtil.array2csv((String[])stringArray)});
                errorMessage.addMessage(i + 1, 2, "SEQUENCE", new String[]{"SEQ=[" + string + "]"});
                System.out.println(errorMessage);
            }
            if (this.isXml) {
                printWriter.println(XML_END_TAG);
            }
            if (printWriter == null) continue;
            printWriter.close();
        }
        return dBTableModel;
    }

    protected String makeHeadLine(int[] nArray, String[] stringArray) {
        String string;
        String string2 = string = stringArray[nArray[2]];
        String string3 = "Created : " + HybsSystem.getDate();
        int[] nArray2 = new int[]{0, 0, 0};
        int[] nArray3 = new int[]{0, 2, 0};
        FixLengthData fixLengthData = new FixLengthData(nArray2, nArray3);
        String[][] stringArray2 = new String[][]{{"/**", CMNT, "**/"}, {"/* ", string2, " */"}, {"/* ", string3, " */"}, {"/**", CMNT, "**/"}};
        fixLengthData.addAllListData(stringArray2);
        return fixLengthData.getAllFixData();
    }

    protected String makeLineList(int[] nArray, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isXml) {
            stringBuilder.append(EXEC_START_TAG).append(CR);
        }
        stringBuilder.append("CREATE SEQUENCE ").append(stringArray[nArray[2]]).append(CR);
        stringBuilder.append("START WITH ").append(stringArray[nArray[4]]).append(CR);
        stringBuilder.append("INCREMENT BY ").append(stringArray[nArray[3]]).append(CR);
        stringBuilder.append("MINVALUE ").append(stringArray[nArray[5]]).append(CR);
        stringBuilder.append("MAXVALUE ").append(stringArray[nArray[6]]).append(CR);
        if ("1".equals(stringArray[nArray[7]])) {
            stringBuilder.append("CYCLE").append(CR);
        } else {
            stringBuilder.append("NOCYCLE").append(CR);
        }
        if (Integer.valueOf(stringArray[nArray[8]]) > 0) {
            stringBuilder.append("CACHE ").append(stringArray[nArray[8]]).append(CR);
        } else {
            stringBuilder.append("NOCACHE").append(CR);
        }
        if (this.isXml) {
            stringBuilder.append(CR).append(EXEC_END_TAG).append(CR);
        } else {
            stringBuilder.append(";").append(CR);
        }
        return stringBuilder.toString();
    }

    static {
        keysMap.put("DIR", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u57fa\u6e96\u30d5\u30a9\u30eb\u30c0(\u5fc5\u9808)");
        keysMap.put("XML", "XML\u51fa\u529b\u3092\u884c\u3046\u304b\u3069\u3046\u304b[true/false]\u3092\u6307\u5b9a(\u521d\u671f\u5024:false)");
        DBKEY = new String[]{"SYSTEM_ID", "TBLSYU", "SEQNAME", "INCREBY", "STARTVAL", "MINVAL", "MAXVAL", "FGCYCLE", "SUCACHE"};
        XML_START_TAG = "<?xml version='1.0' encoding='UTF-8'?>" + CR + "<ROWSET tableName='xxx'>";
    }
}

