/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.taglib.ChartCreateTag;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ChartDatasetTag
extends CommonTagSupport {
    private static final String VERSION = "5.5.2.1 (2012/05/07)";
    private static final long serialVersionUID = 552120120507L;
    private transient ChartDataset chDataset = new ChartDataset();
    private String dbid = null;
    private String sql = null;
    private boolean useTableData = false;
    private String tableId = "h_tblmdl";

    @Override
    public int doStartTag() {
        if (this.useTableData) {
            DBTableModel dBTableModel = (DBTableModel)this.getObject("h_tblmdl");
            this.chDataset.makeDataset(dBTableModel);
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql != null && this.sql.length() > 0) {
            this.sql = this.sql.trim();
        }
        boolean bl = true;
        Connection connection = null;
        try {
            connection = ConnectionFactory.connection((String)this.dbid, (ApplicationInfo)this.getApplicationInfo());
            this.chDataset.makeDataset(connection, this.sql);
            bl = false;
        }
        catch (SQLException sQLException) {
            String string = "\u30c7\u30fc\u30bf\u30bb\u30c3\u30c8\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " SQL=" + this.sql + HybsSystem.CR + sQLException.getMessage();
            throw new HybsSystemException(string, sQLException);
        }
        finally {
            if (bl) {
                ConnectionFactory.remove((Connection)connection, (String)this.dbid);
            } else {
                ConnectionFactory.close((Connection)connection, (String)this.dbid);
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        ChartCreateTag chartCreateTag = (ChartCreateTag)ChartDatasetTag.findAncestorWithClass((Tag)this, ChartCreateTag.class);
        if (chartCreateTag == null) {
            String string = "chartCreate \u30bf\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            throw new HybsSystemException(string);
        }
        chartCreateTag.addChartDataset(this.chDataset);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.chDataset = new ChartDataset();
        this.dbid = null;
        this.sql = null;
        this.useTableData = false;
        this.tableId = "h_tblmdl";
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setChartType(String string) {
        this.chDataset.setChartType(this.getRequestParameter(string));
    }

    public void setUseTableData(String string) {
        this.useTableData = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTableData);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setBaseLegend(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setBaseLegend(bl);
    }

    public void setValueLabel(String string) {
        this.chDataset.setValueLabel(this.getRequestParameter(string));
    }

    public void setMarkValues(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setMarkValues(StringUtil.csv2Array((String)string2));
        }
    }

    public void setUseMarkAnchor(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setUseMarkAnchor(bl);
    }

    public void setMarkColors(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setMarkColors(StringUtil.csv2Array((String)string2));
        }
    }

    public void setMarkOverColors(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setMarkOverColors(StringUtil.csv2Array((String)string2));
        }
    }

    public void setDynamicOCNo(String string) {
        int n = StringUtil.nval((String)this.getRequestParameter(string), (int)-1);
        this.chDataset.setDynamicOCNo(n);
    }

    public void setLowerBound(String string) {
        this.chDataset.setLowerBound(this.getRequestParameter(string));
    }

    public void setUpperBound(String string) {
        this.chDataset.setUpperBound(this.getRequestParameter(string));
    }

    public void setTickSize(String string) {
        this.chDataset.setTickSize(this.getRequestParameter(string));
    }

    public void setUseGradient(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)false);
        this.chDataset.setUseGradient(bl);
    }

    public void setShapesVisible(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setShapesVisible(bl);
    }

    public void setShapeColors(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setShapeColors(StringUtil.csv2Array((String)string2));
        }
    }

    public void setShapeScale(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setShapeScale(string2);
        }
    }

    public void setUseDottedLine(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)false);
        this.chDataset.setUseDottedLine(bl);
    }

    public void setSeriesColors(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.chDataset.setSeriesColors(StringUtil.csv2Array((String)string2));
        }
    }

    public void setValueLabelsVisible(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setValueLabelsVisible(bl);
    }

    public void setValueMarksVisible(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setValueMarksVisible(bl);
    }

    public void setItemLabelVisible(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), (String)"false");
        this.chDataset.setItemLabelVisible(string2);
    }

    public void setUseItemLabelSep(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)true);
        this.chDataset.setUseItemLabelSep(bl);
    }

    public void setValueInset(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setValueInset(string2);
    }

    public void setBarWidth(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setBarWidth(string2);
    }

    public void setBarMaxWidth(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setBarMaxWidth(string2);
    }

    public void setBarItemMargin(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setBarItemMargin(string2);
    }

    public void setVisibleLimit(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setVisibleLimit(string2);
    }

    public void setDomainMargin(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            double d = Double.parseDouble(string2);
            this.chDataset.setDomainMargin(d);
        }
    }

    public void setTimeFormatType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.chDataset.setTimeFormatType(string2);
    }

    public void setUseVerticalLabels(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)false);
        this.chDataset.setUseVerticalLabels(bl);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.chDataset = new ChartDataset();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[").append(((Object)((Object)this)).getClass().getName()).append("]").append(HybsSystem.CR);
        stringBuilder.append("dbid        [").append(this.dbid).append("]").append(HybsSystem.CR);
        stringBuilder.append("sql         [").append(this.sql).append("]").append(HybsSystem.CR);
        stringBuilder.append("dataset     [").append(this.chDataset).append("]").append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

