/****************************************************************************/
/* GF08 ( テーブル関連定義 )                                                */
/*                                                                          */
/* Created : 2013/07/05 19:03:08                                            */
/****************************************************************************/
CREATE TABLE GF08 (
   SYSTEM_ID    VARCHAR2 ( 10 )                 NOT NULL            /*  10 システムID       */
 , TBLSYU       VARCHAR2 (  1 )                 NOT NULL            /*  20 テーブル種別     */
 , TABLE_NAME_L VARCHAR2 ( 50 )                 NOT NULL            /*  30 テーブル名(左)   */
 , CLM_L        VARCHAR2 ( 30 )                 NOT NULL            /*  40 項目(左)         */
 , TABLE_NAME_R VARCHAR2 ( 50 )                 NOT NULL            /*  50 テーブル名(右)   */
 , CLM_R        VARCHAR2 ( 30 )                 NOT NULL            /*  60 項目(右)         */
 , SEQNO        NUMBER   (  7 )     DEFAULT 0   NOT NULL            /*  70 表示順           */
 , UNIQ         NUMBER   (  9 )     DEFAULT 0   NOT NULL            /*  80 ユニークキー     */
 , FGJ          VARCHAR2 (  1 )     DEFAULT '1' NOT NULL            /*  90 状態フラグ       */
 , JOINTYPE     VARCHAR2 (  1 )     DEFAULT '1' NOT NULL            /* 100 連携タイプ       */
 , DYSET        VARCHAR2 ( 14 )                                     /* 110 登録日時         */
 , PGSET        VARCHAR2 ( 10 )                                     /* 120 作成PG           */
 , PGPSET       VARCHAR2 ( 10 )                                     /* 130 作成親PG         */
 , USRSET       VARCHAR2 ( 10 )                                     /* 140 作成社員         */
 , DYUPD        VARCHAR2 ( 14 )                                     /* 150 更新日時         */
 , PGUPD        VARCHAR2 ( 10 )                                     /* 160 更新PG           */
 , PGPUPD       VARCHAR2 ( 10 )                                     /* 170 更新親PG         */
 , USRUPD       VARCHAR2 ( 10 )                                     /* 180 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF08S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF08T00 
BEFORE INSERT ON GF08
FOR EACH ROW 
BEGIN 
SELECT GF08S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

