<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select case c.relkind when 't' then 'TRIGGER'
						  when 'S' then 'SEQUENCE'
						  when 'r' then 'TABLE'
						  when 'i' then 'INDEX'
						  when 'v' then 'VIEW'
						  else 'NV' end as OBJ_TYPE ,
			c.relname as OBJ_NAME ,
			c.relname as NAME_JA ,
			'VALID' AS STTS ,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	FROM pg_class c LEFT join pg_user u 
	ON c.relowner = u.usesysid
	where u.usename != 'postgres'
	and   c.relkind  not in ( 'r','i' )		-- TABLE,INDEX を除く
	<og:where startKey="and">
		<og:and value="( 'VIEW' = '{@OBJ_TYPE2}' and c.relkind = 'v' ) or ( 'TRIGGER' = '{@OBJ_TYPE2}' and c.relkind = 't' ) or ( 'FUNCTION' = '{@OBJ_TYPE2}' and c.relkind = 'S')"	/>
		<og:and value="c.relname like	'{@OBJ_NAME}%'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select OBJECT_TYPE  as OBJ_TYPE,
			OBJECT_NAME as OBJ_NAME,
			OBJECT_NAME AS NAME_JA,
			STATUS AS STTS ,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from USER_OBJECTS
	where INSTR(OBJECT_NAME,'$') < 1
	and   OBJECT_TYPE  not in ( 'TABLE','INDEX' )
	<og:where startKey="and">
		<og:and value="OBJECT_TYPE =	'{@OBJ_TYPE2}'"	/>
		<og:and value="OBJECT_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select 'SEQUENCE'			as OBJ_TYPE,
			RDB$GENERATOR_NAME	as OBJ_NAME,
			RDB$GENERATOR_NAME	as NAME_JA,
			'VALID'				as STTS,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from RDB$GENERATORS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'SEQUENCE'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$GENERATOR_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
	union
	select 'VIEW'				as OBJ_TYPE,
			RDB$RELATION_NAME	as OBJ_NAME,
			RDB$RELATION_NAME	as NAME_JA,
			'VALID'				as STTS,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from RDB$RELATIONS
	where RDB$SYSTEM_FLAG = 0
	and   RDB$VIEW_BLR is not null
	<og:where startKey="and">
		<og:and value="'VIEW'			=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$RELATION_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
	union
	select 'TRIGGER'			as OBJ_TYPE,
			RDB$TRIGGER_NAME	as OBJ_NAME,
			RDB$TRIGGER_NAME	as NAME_JA,
			case when RDB$TRIGGER_INACTIVE = 0 then 'VALID' else 'INVALID' end as STTS,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from RDB$TRIGGERS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'TRIGGER'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$TRIGGER_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
	union
	select 'PROCEDURE'			as OBJ_TYPE,
			RDB$PROCEDURE_NAME	as OBJ_NAME,
			RDB$PROCEDURE_NAME	as NAME_JA,
			'VALID'				as STTS,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from RDB$PROCEDURES
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'PROCEDURE'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$PROCEDURE_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
	union
	select 'FUNCTION'			as OBJ_TYPE,
			RDB$FUNCTION_NAME	as OBJ_NAME,
			RDB$FUNCTION_NAME	as NAME_JA,
			'VALID'				as STTS,
			'{@MEM.SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
	from RDB$FUNCTIONS
	where RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="'FUNCTION'		=		'{@OBJ_TYPE2}'"	/>
		<og:and value="RDB$FUNCTION_NAME like	'{@OBJ_NAME}%'"	/>
	</og:where>
  </og:query>
</og:equals>
