<?xml version="1.0" encoding="UTF-8"?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page" xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld" version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= ""
	pgid	= "GF2250"
	title	= "青紙定義"
	date	= "2010/07/24"
	author	= "Auto Create"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck command="{@command}" columns="SYSTEM_ID,PGID" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
		select
			A1.SYSTEM_ID,A1.PGID,A1.SEQ,A1.NMPG,A1.PGLANG,A1.SIYOSAKU,A1.PGSAKU,
			A1.PGKEN,A1.DYSAKU,A1.DYKAN,A1.DYKEN,A1.CDSAKU,A1.GUITYPE,A1.HPGID,A1.SPGID,A1.FGGAMEN,A1.GAIYO,A1.FGJ,A1.UNIQ
		from GF90 A1
	<og:where>
		<og:and value = "A1.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A1.PGID		like	'{@PGID}%'"	/>
		<og:and value = "A1.NMPG		like	'{@NMPG}%'"	/>
		<og:and value = "A1.SIYOSAKU	like	'{@SIYOSAKU}%'"	/>
		<og:and value = "A1.PGSAKU		like	'{@PGSAKU}%'"	/>
		<og:and value = "A1.PGKEN		like	'{@PGKEN}%'"	/>
		<og:and value = "A1.GUITYPE		=	'{@GUITYPE}'"	/>
		<og:and value = "A1.HPGID		like	'{@HPGID}%'"	/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
			defaultVal = "A1.SYSTEM_ID,A1.SEQ" />

</og:query>


<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="null" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="SYSTEM_ID,PGID"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "FGJ,UNIQ"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
