<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6100"
	title	= "カレンダー登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- forward.jsp から command = "COPY" がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}"  repeatCount="{@repeatCount}">
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<og:columnSet command="{@command}" columnId="YYYYMM" action="ADD"  />
	<og:columnSet command="{@command}" columnId="YYYYMM" action="NULLSET" value="{@USER.YMD}" />
</og:entry>

<og:message lbl="MSG0045" comment="複写処理を行います。" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)入力リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType = "HTMLCalendar"
	command      = "{@command}"
	startNo      = "{@startNo}"
	noWritable   = "FGJ"
	pageSize     = "{@pageSize}"
/>

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GF13
		(DY1,DY2,DY3,DY4,DY5,DY6,DY7,DY8,DY9,DY10,
		 DY11,DY12,DY13,DY14,DY15,DY16,DY17,DY18,DY19,DY20,
		 DY21,DY22,DY23,DY24,DY25,DY26,DY27,DY28,DY29,DY30,DY31,
		 YYYYMM,CDJGS,
		 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([DY1],[DY2],[DY3],[DY4],[DY5],[DY6],[DY7],[DY8],[DY9],[DY10],
		 [DY11],[DY12],[DY13],[DY14],[DY15],[DY16],[DY17],[DY18],[DY19],[DY20],
		 [DY21],[DY22],[DY23],[DY24],[DY25],[DY26],[DY27],[DY28],[DY29],[DY30],[DY31],
		 [YYYYMM],[CDJGS],
		 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','CALENDAR')
  </jsp:text>
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
