<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" adjustEvent="Bar" >
	<style>
		/* iHead の leftVal 修飾 */
		div.leftAdjustBar{
			font-size:small;
			color:red;
		}

		/* iHead の rightVal 修飾 */
		div.rightAdjustBar{
			font-size:small;
			color:red;
		}
		div.iBarDiv{
			font-size:smal;
			color:white;
		}
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7203"
	title	= "横棒グラフ（明細）"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力ﾁｪｯｸ -->
<og:columnCheck
	command   = "{@command}"
	columns   = "NOORDER ,KNORDER_F ,KNORDER_T ,NMCUST"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT   NOORDER													NOORDER		<!-- 受注NO		-->
			,KNORDER													KNORDER		<!-- 受注金額	-->
			,KNJISK														KNJISK		<!-- 合計原価	-->
			,KNMIKM														KNMIKM		<!-- 見込		-->
			,KNORDER													KNORDER_G	<!-- 受注金額	-->
			,KNJISK														KNJISK_G	<!-- 合計原価	-->
			,KNMIKM														KNMIKM_G	<!-- 見込		-->
			,NMCUST														NMCUST		<!-- 納入先名 	-->
			,SINTYOKU													SINTYOKU_G	<!-- 進捗率		-->
			,SINTYOKU * 100 ||'%'										SINTYOKU 	<!-- 進捗率		-->
			, case when SINTYOKU * 100 &lt; 20 then 'red' else 'blue' end as COLOR
	FROM GF45
	<og:where>
		<og:and value = "NOORDER			=		'{@NOORDER}'" 	/>		<!-- GRA01》受注NO   ＝ 画面》受注NO -->
		<og:and value = "KNORDER		&gt;=		'{@KNORDER_F}'"	/>		<!-- GRA01》受注金額 ＝ 画面》受注金額(From) -->
		<og:and value = "KNORDER		&lt;=		'{@KNORDER_T}'"	/>		<!-- GRA01》受注金額 ＝ 画面》受注金額(tO) -->
		<og:and value = "NMCUST				LIKE	'{@NMCUST}'"	/>		<!-- GRA01》受注NO   ＝ 画面》受注NO -->
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="NOORDER" />
</og:query>
<!-- DB検索結果を表示 -->
<og:columnEditor columns="SINTYOKU_G ,KNORDER ,KNJISK ,KNMIKM" dbType="KX" />
<og:view
	viewFormType = "HTMLCustomTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
	headerSkipCount="10"
>
	<og:thead rowspan="2">
		<tr>
			<td rowspan="2">		[NOORDER]		</td>		<!-- 受注NO		-->
			<td colspan="2">		[KNORDER]		</td>		<!-- 受注金額	-->
			<td rowspan="2">		[NMCUST]		</td>		<!-- 納入先名	-->
			<td rowspan="2">
				<og:iHead width="150px"
						leftVal ="now"		leftLoc ="0.8"	leftBorderStyle ="solid red 1px"	adjustLeft ="15px" 
						rightVal="Target"	rightLoc="1.0"	rightBorderStyle="dashed red 2px"	adjustRight="-15px" />
			</td>		<!-- ｸﾞﾗﾌﾍｯﾀﾞｰ	-->
			<td rowspan="2">		[SINTYOKU]		</td>		<!-- 進捗率		-->
		</tr>
		<tr>
			<td>					[KNJISK]		</td>		<!-- 合計原価	-->
			<td>					[KNMIKM]		</td>		<!-- 見込		-->
		</tr>
	</og:thead>
	<og:tbody rowspan="2">
		<tr>
			<td rowspan="2">		[NOORDER]		</td>		<!-- 受注NO		-->
			<td colspan="2">		[KNORDER]		</td>		<!-- 受注金額	-->
			<td rowspan="2">		[NMCUST]		</td>		<!-- 納入先名	-->
			<td rowspan="2">									<!-- グラフ雛型 -->
				<og:iBar type="0" value="[SINTYOKU]" baseVal="[KNORDER]" />	<!-- type="0" ラベル（進捗率）、baseCol:位置計算の分母 -->
				<og:iBar type="1" value="[KNORDER_G]" color="[COLOR]" text="[KNORDER]" optionAttributes='{"title" : "[KNORDER]"}' />		<!-- type="1" バーの描画、colorはバーの色 -->
				<br/>
				<og:iBar type="1" value="[KNJISK_G],[KNMIKM_G]" color="black,green" />
				<og:iBar type="2" value="[KNJISK_G],[KNMIKM_G]" baseVal="[KNORDER_G]" color="green" /> <!-- type="2" 差分の枠線 -->
				<og:iBar type="2" value="[KNORDER_G]"           baseVal="[KNJISK_G],[KNMIKM_G]" /> <!-- type="2" 差分の枠線(不足分) -->
			</td>
			<td rowspan="2">		[SINTYOKU]		</td>		<!-- 進捗率		-->
		</tr>
		<tr>
			<td>					[KNJISK]		</td>		<!-- 合計原価	-->
			<td>					[KNMIKM]		</td>		<!-- 見込		-->
		</tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
