/****************************************************************************/
/* GEA10 ( ユーザー定義 )                                                   */
/*                                                                          */
/* Created : 2013/07/17 17:13:36                                            */
/****************************************************************************/
CREATE TABLE GEA10 (
   SYSTEM_ID    VARCHAR2 (  10 )                            NOT NULL            /*  10 システムID           */
 , USERID       VARCHAR2 (  10 )                            NOT NULL            /*  20 ユーザーID           */
 , PASSWD       VARCHAR2 (  32 )                            NOT NULL            /*  30 パスワード           */
 , LANG         VARCHAR2 (   2 )                            NOT NULL            /*  40 言語                 */
 , NAME_JA      VARCHAR2 ( 200 )                                                /*  50 名称                 */
 , ROLES        VARCHAR2 ( 500 )                            NOT NULL            /*  60 ロールズ             */
 , DROLES       VARCHAR2 ( 500 )                                                /*  70 データロールズ       */
 , COMMENTS     VARCHAR2 ( 500 )                                                /*  80 コメント             */
 , DYPASSWD     VARCHAR2 (  14 )                                                /*  90 パスワード変更日時   */
 , DYVALID      VARCHAR2 (   8 )        DEFAULT '99999999'  NOT NULL            /* 100 有効日               */
 , FGDEFAULT    VARCHAR2 (   1 )        DEFAULT '0'                             /* 110 ログインFG           */
 , MAILAD       VARCHAR2 ( 100 )                                                /* 120 メールアドレス       */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0           NOT NULL            /* 130 ユニークキー         */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1'         NOT NULL            /* 140 状態フラグ           */
 , DYSET        VARCHAR2 (  14 )                                                /* 150 登録日時             */
 , PGSET        VARCHAR2 (  10 )                                                /* 160 作成PG               */
 , PGPSET       VARCHAR2 (  10 )                                                /* 170 作成親PG             */
 , USRSET       VARCHAR2 (  10 )                                                /* 180 作成社員             */
 , DYUPD        VARCHAR2 (  14 )                                                /* 190 更新日時             */
 , PGUPD        VARCHAR2 (  10 )                                                /* 200 更新PG               */
 , PGPUPD       VARCHAR2 (  10 )                                                /* 210 更新親PG             */
 , USRUPD       VARCHAR2 (  10 )                                                /* 220 更新者               */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA10S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA10T00 
BEFORE INSERT ON GEA10
FOR EACH ROW 
BEGIN 
SELECT GEA10S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

