/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.EnumType;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.LogSender;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.UserSummary;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.UserInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ErrorTag
extends CommonTagSupport {
    private static final String VERSION = "5.1.8.0 (2010/07/01)";
    private static final long serialVersionUID = 518020100701L;
    private static final EnumType<String> LOG_MSGTYPE = new EnumType("\u30ed\u30b0\u30e1\u30c3\u30bb\u30fc\u30b8\u30bf\u30a4\u30d7", (Comparable)((Object)"MEDIUM")).append((Comparable)((Object)"LONG"), "\u8a73\u7d30\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"MEDIUM"), "\u6a19\u6e96\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"SHORT"), "\u7c21\u6613\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"NONE"), "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u305b\u3093\u3002");
    private static final EnumType<String> VIEW_MSGTYPE = new EnumType("\u8868\u793a\u30e1\u30c3\u30bb\u30fc\u30b8\u30bf\u30a4\u30d7", (Comparable)((Object)"SHORT")).append((Comparable)((Object)"LONG"), "\u8a73\u7d30\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"MEDIUM"), "\u6a19\u6e96\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"SHORT"), "\u7c21\u6613\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"NONE"), "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u305b\u3093\u3002").append((Comparable)((Object)"ALLNONE"), "\u4f55\u3082\u51fa\u529b\u3057\u307e\u305b\u3093\u3002").append((Comparable)((Object)"TABLE"), "\u30c6\u30fc\u30d6\u30eb\u5f62\u5f0f\u3067\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u307f\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
    private final String MAIL_SERVER = StringUtil.nval((String)HybsSystem.sys("COMMON_MAIL_SERVER"), null);
    private final String MAIL_USERS = StringUtil.nval((String)HybsSystem.sys("ERROR_MAIL_TO_USERS"), null);
    private final String FROM_USER = StringUtil.nval((String)HybsSystem.sys("ERROR_MAIL_FROM_USER"), (String)"ENGINE@DUMMY");
    private final String TITLE = "\u3010" + HybsSystem.sys("SYSTEM_ID") + "\u3011" + HybsSystem.sys("GUI_TOP_TITLE") + "Error!";
    private boolean useMail = true;
    private String logMsgType = (String)((Object)LOG_MSGTYPE.getDefault());
    private String viewMsgType = (String)((Object)VIEW_MSGTYPE.getDefault());
    private boolean skipPage = false;
    private String messageBody = null;

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.messageBody = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        Object object;
        String string;
        Comparable<UserSummary> comparable;
        this.debugPrint();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(HybsSystem.CR);
        stringBuilder.append("Title :").append(this.TITLE).append(HybsSystem.CR);
        stringBuilder.append("Version :").append("openGion 5.7.1.0 Release5 Builds (13343)").append(HybsSystem.CR);
        String string2 = null;
        try {
            comparable = this.getUser();
            string2 = ((UserInfo)comparable).getUserID();
            stringBuilder.append("ID=[").append(string2);
            stringBuilder.append("] LOGIN=[").append(HybsSystem.getDate(((UserInfo)comparable).getLoginTime()));
            stringBuilder.append("]");
        }
        catch (HybsSystemException hybsSystemException) {
            stringBuilder.append("User is null");
        }
        stringBuilder.append(HybsSystem.CR);
        comparable = (GUIInfo)this.getSessionAttribute("h_gInfo");
        stringBuilder.append("GUI Information  : ");
        if (comparable != null) {
            ((GUIInfo)comparable).addErrorCount();
            string = ((GUIInfo)comparable).getKey();
            stringBuilder.append("KEY=[").append(string);
            stringBuilder.append("] LABEL=[").append(((GUIInfo)comparable).getLabel());
            stringBuilder.append("]");
        } else {
            string = null;
            stringBuilder.append("GUI is null");
        }
        stringBuilder.append(HybsSystem.CR);
        Exception exception = this.pageContext.getException();
        if (exception != null) {
            stringBuilder.append(exception.getMessage()).append(HybsSystem.CR);
        }
        stringBuilder.append("-----").append(HybsSystem.CR);
        String string3 = stringBuilder.toString();
        String string4 = this.getStackTrace(exception, this.logMsgType);
        LogSender logSender = new LogSender(string2);
        logSender.setGuiId(string);
        logSender.setMsgId(this.messageBody);
        logSender.error(string3);
        logSender.error(string4);
        logSender.flush();
        if (this.useMail && this.MAIL_SERVER != null && this.MAIL_USERS != null) {
            object = StringUtil.csv2Array((String)this.MAIL_USERS);
            MailTX mailTX = new MailTX(this.MAIL_SERVER);
            mailTX.setFrom(this.FROM_USER);
            mailTX.setTo(object);
            mailTX.setSubject(this.TITLE);
            mailTX.setMessage(string3 + string4);
            mailTX.sendmail();
        }
        if (!"ALLNONE".equals(this.viewMsgType)) {
            object = this.logMsgType.equals(this.viewMsgType) ? string3 + string4 : ("TABLE".equals(this.viewMsgType) ? this.getTableMsg(this.pageContext.getException()) : string3 + this.getStackTrace(this.pageContext.getException(), this.viewMsgType));
            this.jspPrint((String)object);
        }
        if (this.skipPage) {
            return 5;
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.useMail = true;
        this.logMsgType = (String)((Object)LOG_MSGTYPE.getDefault());
        this.viewMsgType = (String)((Object)VIEW_MSGTYPE.getDefault());
        this.skipPage = false;
        this.messageBody = null;
    }

    private String getStackTrace(Throwable throwable, String string) {
        if ("NONE".equals(string) || "ALLNONE".equals(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            stringBuilder2 = this.getStackData(stringBuilder2, throwable2, string);
            String string2 = throwable2.getMessage();
            if (string2 == null || stringBuilder.indexOf(string2) >= 0) continue;
            stringBuilder.append(string2).append(HybsSystem.CR);
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append("------------------------------------------------------").append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    private StringBuilder getStackData(StringBuilder stringBuilder, Throwable throwable, String string) {
        if ("NONE".equals(string) || "ALLNONE".equals(string)) {
            return stringBuilder;
        }
        String string2 = "org.opengion.";
        int n = 5;
        if ("LONG".equals(string)) {
            string2 = "";
            n = 100;
        }
        if ("SHORT".equals(string)) {
            n = 0;
        }
        if (throwable != null) {
            int n2 = 0;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                String string3 = stackTraceElementArray[i].toString();
                if (string3 == null || stringBuilder.indexOf(string3) >= 0) continue;
                if (string3.indexOf(string2) >= 0) {
                    stringBuilder.append("\tat ").append(string3).append(HybsSystem.CR);
                    if (!"SHORT".equals(string)) continue;
                    break;
                }
                if (n2++ >= n) continue;
                stringBuilder.append("\tat ").append(string3).append(HybsSystem.CR);
            }
            stringBuilder.append("\t   ... more ...").append(HybsSystem.CR);
        }
        return stringBuilder;
    }

    private String getTableMsg(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(200);
        ErrorMessage errorMessage = new ErrorMessage("System Error!");
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            String string = StringUtil.nval((String)throwable2.getMessage(), (String)"System Error(null)");
            if (string == null || stringBuilder.indexOf(string) >= 0) continue;
            stringBuilder.append(string);
            errorMessage.addMessage(0, 2, "SYSERR", new String[]{string});
        }
        return TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource());
    }

    public void setUseMail(String string) {
        this.useMail = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMail);
    }

    public void setLogMsgType(String string) {
        this.logMsgType = (String)((Object)LOG_MSGTYPE.nval(string));
    }

    public void setViewMsgType(String string) {
        this.viewMsgType = (String)((Object)VIEW_MSGTYPE.nval(string));
    }

    public void setSkipPage(String string) {
        this.skipPage = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.skipPage);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("useMail", (Object)this.useMail).println("logMsgType", (Object)this.logMsgType).println("viewMsgType", (Object)this.viewMsgType).println("messageBody", (Object)this.messageBody).println("skipPage", (Object)this.skipPage).println("COMMON_MAIL_SERVER", (Object)this.MAIL_SERVER).println("ERROR_MAIL_TO_USERS", (Object)this.MAIL_USERS).println("MAIL_DAEMON_DEFAULT_USER", (Object)this.FROM_USER).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

