<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <TBLSYU    ><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:query | //og:update | //og:plsqlUpdate | //og:tableUpdate | //og:entryQuery" />
    <xsl:apply-templates select="//og:value[@command='SQL'] | //og:userInfo[@command='SQL'] | //og:tableUpdateParam" />
    <xsl:apply-templates select="//og:writeTableParam[@key='MergeSql']" />
    <xsl:apply-templates select="//og:queryOption" />
    <xsl:apply-templates select="//og:directWriteTable" />
    <xsl:apply-templates select="//og:tableFilter[@classId='DBSELECT']" />
    <xsl:apply-templates select="//og:chartDataset" />
    <xsl:apply-templates select="//og:dataCheck" />
    <xsl:apply-templates select="//og:columnEditor" />
    <xsl:apply-templates select="//og:hidden" />
  </xsl:template>

  <xsl:template match="og:query | og:update | og:plsqlUpdate | og:tableUpdate | og:entryQuery">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:value[@command='SQL'] | og:userInfo[@command='SQL'] | og:tableUpdateParam">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  ><xsl:value-of select="@sqlType"   /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:writeTableParam[@key='MergeSql']">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      />
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:queryOption">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID   />
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:directWriteTable">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:tableFilter[@classId='DBSELECT']">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ></CLMS>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:chartDataset">
	<xsl:if test="not(@useTableData='true')" >
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      />
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:dataCheck">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      />
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@sqlType"   /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:columnEditor">
	<xsl:if test="(@renderer='DBMENU' or @editor='DBMENU')" >
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      />
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:hidden">
	<xsl:if test="contains(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ),'SELECT')" >
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      />
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>
