<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page errorPage="/jsp/common/error.jsp" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:columnCheck
	command   = "NEW"
/>

<!-- TYPE 定義のソースを取得 -->
<jsp:directive.include file="sqlGF81.jsp" />

<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- 元のTYPE定義を削除する。 -->
	<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request">
			DELETE FROM GF81
			WHERE SYSTEM_ID = '{@SYSTEM_ID}'
			AND   TBLSYU    = '{@TBLSYU}'
	</og:query>

	<!-- 上で作成した 新しいTYPE定義を、追加する。 -->
	<og:tableUpdate command="ENTRY" sqlType="INSERT" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF81"
			omitNames	= "TEXT"
		/>
	</og:tableUpdate>

	<!-- 最も適合すると思われるテーブル名を取得する。 -->
	<!--
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select B.OBJ_NAME,A.TABLE_NAME,A.CLM , count(*) as CNT
		from GF80 A inner join GF81 B
			on	A.CLM         = B.CLM
			and	A.SYSTEM_ID   = B.SYSTEM_ID
			and	A.TBLSYU      = B.TBLSYU
		where B.SYSTEM_ID	=  '{@SYSTEM_ID}'
		and   B.TBLSYU		=  '{@TBLSYU}'
		group by B.OBJ_NAME,A.TABLE_NAME,A.CLM
		order by B.OBJ_NAME,CNT DESC,A.TABLE_NAME
	</og:query>
	-->

	<!-- 取り出したテーブル名を、マージする。 -->
	<!--
	<og:tableMerge
		action     = "UNION_CLM"
		slaveKeys  = "OBJ_NAME,CLM"
		unionClms  = "TABLE_NAME"
	/>
	-->

	<!-- 実スキーマ から、カラムの最大桁数を取得 -->
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0" scope="request">
			select TABLE_NAME , COLUMN_NAME AS CLM ,
				( CASE WHEN DATA_PRECISION IS NULL 
							THEN to_char(DATA_LENGTH)
							ELSE to_char(DATA_PRECISION) ||
									CASE WHEN DATA_SCALE = 0
											THEN NULL
											ELSE ',' || to_char(DATA_SCALE)
									END
					END
				) as MAX_LENGTH
			from USER_TAB_COLUMNS
			where INSTR(TABLE_NAME,'$') &lt; 1
	</og:query>

	<!-- 取り出した最大桁数を、マージする。 -->
	<og:tableMerge
		action     = "UNION_CLM"
		slaveKeys  = "TABLE_NAME,CLM"
		unionClms  = "MAX_LENGTH"
	/>

	<!-- TABLE_NAME と MAX_LENGTH を、更新する。 -->
	<og:tableUpdate command="ENTRY" sqlType="UPDATE" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "UPDATE"
			table		= "GF81"
			names		= "TABLE_NAME,MAX_LENGTH"
			where		= "SYSTEM_ID='{@SYSTEM_ID}' and TBLSYU='{@TBLSYU}' and OBJ_NAME=[OBJ_NAME] and CLM=[CLM]"
		/>
	</og:tableUpdate>

</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
