<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select 	c.relname AS SEQNAME ,
			1		AS INCREBY ,
			1		AS STARTVAL ,
			1		AS MINVAL ,
			0		AS MAXVAL ,
			'0'		AS FGCYCLE ,
			0		AS SUCACHE ,
			''		AS TABLE_NAME,
			''		AS CLM ,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}'    AS TBLSYU
	FROM pg_class c LEFT join pg_user u 
	ON c.relowner = u.usesysid
	where u.usename != 'postgres'
	and   c.relkind  = 'S'						-- SEQUENCE
	<og:where startKey="and">
		<og:and value="'SEQUENCE' = '{@OBJ_TYPE2}'"		/>
		<og:and value="c.relname like	'{@OBJ_NAME}%'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select SEQUENCE_NAME	AS SEQNAME ,
			MIN_VALUE		AS MINVAL ,
			MAX_VALUE		AS MAXVAL ,
			INCREMENT_BY	AS INCREBY ,
			CYCLE_FLAG		AS FGCYCLE ,
			CACHE_SIZE		AS SUCACHE ,
			''				AS TABLE_NAME,
			''				AS CLM ,
			'{@SYSTEM_ID}'	AS SYSTEM_ID,
			'{@TBLSYU}'			AS TBLSYU
	from USER_SEQUENCES
	<og:where>
		<og:and value="SEQUENCE_NAME like	'{@SEQNAME}%'"	/>
		<og:and value="'SEQUENCE'	 =		'{@OBJ_TYPE2}'" />
	</og:where>
		order by SEQUENCE_NAME
  </og:query>

	<!-- ｼｰｹﾝｽを参照しているｵﾌﾞｼﾞｪｸﾄ(主にﾄﾘｶﾞ)が参照しているﾃｰﾌﾞﾙ名を取り出して、セットします -->
	<og:tableFilter
		classId	= "DBSELECT"
		dbid	= "{@DBID}"
		selectedAll	= "true"
	>
		select REFERENCED_NAME AS TABLE_NAME
		from user_dependencies
		where (TYPE,NAME) in (
			select TYPE,NAME from user_dependencies
			where REFERENCED_TYPE = 'SEQUENCE'
			and   REFERENCED_NAME = [SEQNAME]
		)
		and REFERENCED_TYPE='TABLE'
		and INSTR(REFERENCED_NAME,'$') < 1
	</og:tableFilter>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	select trim(RDB$GENERATOR_NAME)	AS SEQNAME ,
			1		AS INCREBY ,
			1		AS STARTVAL ,
			1		AS MINVAL ,
			0		AS MAXVAL ,
			'0'		AS FGCYCLE ,
			0		AS SUCACHE ,
			''				AS TABLE_NAME,
			''				AS CLM ,
			'{@SYSTEM_ID}'	AS SYSTEM_ID,
			'{@TBLSYU}'		AS TBLSYU
	from RDB$GENERATORS
	where   RDB$SYSTEM_FLAG = 0
	<og:where startKey="and">
		<og:and value="RDB$GENERATOR_NAME like	'{@SEQNAME}%'"	/>
		<og:and value="'SEQUENCE'	 		=	'{@OBJ_TYPE2}'" />
	</og:where>
		order by RDB$GENERATOR_NAME
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2082}" val1="{@DBF.NAME @DBID}" />
</og:equals>
