<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<style type="text/css">
		.x7698 { background-color:#ccff00; }
		.MANAGER { background-color:#ccff00; }
	</style>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT DEPTNO,{@CUBE_X},{@CUBE_Y},SUM(SAL) AS KEI
		FROM EMP
		GROUP BY DEPTNO,CUBE({@CUBE_X},{@CUBE_Y})
		HAVING DEPTNO IS NOT NULL OR ( DEPTNO IS NULL AND JOB IS NULL )
		ORDER BY DEPTNO ,{@CUBE_X} ,{@CUBE_Y}
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="{@CUBE_X}" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,{@CUBE_X},KEI"
		vals="NEW,[{@CUBE_X}],[KEI]" />
	<og:link column="KEI" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,KEI"
		vals="NEW,[KEI]" />
  <og:equals val1="{@useHeaderColumn}" val2="true" >
	<og:link column="7839" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,JOB,SUM"
		vals="NEW,[JOB],[7839]" />
	<og:link column="7788" gamenId="GF9000" href="index.jsp" target="CONTENTS" onLink="[DEPTNO]" markList="20"
		keys="command,JOB,SUM"
		vals="NEW,[JOB],[7788]" />
  </og:equals>
</og:viewLink>

<og:view
	viewFormType = "HTMLCrossTable"
	command		= "{@command}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
	useParam	= "true"
  >
	<og:crossParam
		cubeXColumn		= "{@CUBE_X}"
		cubeYColumn		= "{@CUBE_Y}"
		gokeiLabel		= "GOKEI"
		cubeSortType	= "{@cubeSortType}"
		gokeiSortDir	= "{@gokeiSortDir}"
		useHeaderColumn = "{@useHeaderColumn}"
		saveTableId		= "{@saveTableId}"
		useClassAdd		= "{@useClassAdd}"
	/>
</og:view>

<og:view />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
