/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.servlet.UploadedFile;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileUploadTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.1.1 (2013/12/13)";
    private static final long serialVersionUID = 571120131213L;
    private static final String[] names = new String[]{"KEY", "VALUE", "ISFILE"};
    private static final String ENCODE = "UTF-8";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = null;
    private int maxPostSize = 0xA00000;
    private String tableId = "h_tblmdl";
    private String columns = null;
    private boolean useBackup = false;

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.startQueryTransaction(this.tableId);
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        try {
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
                throw new HybsSystemException(string2);
            }
            MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, this.filename, this.useBackup);
            DBTableModel dBTableModel = null;
            dBTableModel = this.columns == null ? this.makeDBTable(multipartRequest) : this.makeDBTableFromClms(multipartRequest);
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("FileUploadTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u767b\u9332\u30a8\u30e9\u30fc\uff01" + iOException.getMessage() + HybsSystem.CR + "(" + this.toString() + HybsSystem.CR + "FileURL=" + this.fileURL + ")";
            throw new HybsSystemException(string, iOException);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.maxPostSize = 0xA00000;
        this.tableId = "h_tblmdl";
        this.filename = null;
        this.columns = null;
        this.useBackup = false;
    }

    private DBTableModel makeDBTable(MultipartRequest multipartRequest) {
        String string;
        String string2;
        Object object;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(names.length);
        for (int i = 0; i < names.length; ++i) {
            object = this.getDBColumn(names[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object);
        }
        object = new ArrayList();
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        for (int i = 0; i < uploadedFileArray.length; ++i) {
            String string3 = uploadedFileArray[i].getName();
            string2 = uploadedFileArray[i].getFilesystemName();
            String[] stringArray = new String[]{string3, string2, "1"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string3, string2);
            object.add(string3);
            string = string3 + "_ORG";
            string2 = uploadedFileArray[i].getOriginalFileName();
            stringArray = new String[]{string, string2, "2"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string, string2);
        }
        String[] stringArray = new String[]{"directory", this.fileURL, "0"};
        dBTableModel.addColumnValues(stringArray);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray2 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = stringArray2[i];
            if ("h_rowSel".equals(string2)) {
                this.setRequestAttribute(string2, multipartRequest.getIntParameters(string2));
                continue;
            }
            string = this.getParamVal(string2, multipartRequest);
            stringArray = new String[]{string2, string, "0"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string2, string);
            object.add(string2);
        }
        this.setParameterNames(object.toArray(new String[object.size()]));
        return dBTableModel;
    }

    private DBTableModel makeDBTableFromClms(MultipartRequest multipartRequest) {
        String string;
        String string2;
        Object object;
        String string3;
        int n;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        String[] stringArray = this.columns.split(",");
        dBTableModel.init(stringArray.length);
        String[] stringArray2 = new String[stringArray.length];
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < stringArray.length; ++n) {
            string3 = stringArray[n];
            object = this.getDBColumn(string3);
            dBTableModel.setDBColumn(n, (DBColumn)object);
            string2 = this.getParamVal(string3, multipartRequest);
            if (string2 == null) {
                for (int i = 0; i < uploadedFileArray.length; ++i) {
                    string = uploadedFileArray[i].getName();
                    if (!string3.equalsIgnoreCase(string)) continue;
                    string2 = uploadedFileArray[i].getFilesystemName();
                    break;
                }
            }
            stringArray2[n] = string2 == null ? "" : string2;
        }
        for (n = 0; n < uploadedFileArray.length; ++n) {
            string3 = uploadedFileArray[n].getName();
            object = new String[stringArray.length];
            System.arraycopy(stringArray2, 0, object, 0, ((String[])object).length);
            string2 = uploadedFileArray[n].getFilesystemName();
            this.setRequestAttribute(string3, string2);
            arrayList.add(string3);
            String string4 = string3 + "_ORG";
            string = uploadedFileArray[n].getOriginalFileName();
            this.setRequestAttribute(string4, string);
            int n2 = string3.lastIndexOf(95);
            if (n2 > 0) {
                String string5 = string3.substring(0, n2);
                String string6 = string3.substring(n2);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string7 = stringArray[i];
                    String string8 = null;
                    String string9 = null;
                    if (string5.equalsIgnoreCase(string7)) {
                        string9 = string2;
                    } else if ((string5 + "_ORG").equalsIgnoreCase(string7)) {
                        string9 = string;
                    } else if ((string5 + "_NEW").equalsIgnoreCase(string7)) {
                        string8 = string3 + "_NEW";
                        string9 = multipartRequest.getParameter(string8);
                    } else {
                        string8 = stringArray[i] + string6;
                        string9 = this.getParamVal(string8, multipartRequest);
                    }
                    if (string9 == null) continue;
                    object[i] = string9;
                }
            }
            dBTableModel.addColumnValues((String[])object);
        }
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray3 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            object = stringArray3[i];
            if ("h_rowSel".equals(object)) {
                this.setRequestAttribute((String)object, multipartRequest.getIntParameters((String)object));
                continue;
            }
            string2 = this.getParamVal((String)object, multipartRequest);
            this.setRequestAttribute((String)object, string2);
            arrayList.add(object);
        }
        this.setParameterNames(arrayList.toArray(new String[arrayList.size()]));
        return dBTableModel;
    }

    private String getParamVal(String string, MultipartRequest multipartRequest) {
        String[] stringArray;
        String string2 = multipartRequest.getParameter(string);
        if ("0".equals(string2) && (stringArray = multipartRequest.getParameters(string)) != null && stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"1".equals(stringArray[i])) continue;
                string2 = "1";
                break;
            }
        }
        return string2;
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setUseBackup(String string) {
        this.useBackup = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBackup);
    }

    @Override
    protected String getTagName() {
        return "upload";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("names", (Object[])names).println("ENCODE", (Object)ENCODE).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("columns", (Object)this.columns).println("useBackup", (Object)this.useBackup).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

