<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useIE7Header="false"  />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6040"
	title	= "Submit"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLE_CLM2"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="entry" lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset" lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<table>
<tr><th>フォーム</th>										<th>説明</th></tr>
<tr><og:input type="search" 		name="search"			> …… 検索テキストの入力欄を作成する			</og:input></tr>
<tr><og:input type="tel"			name="tel"				> …… 電話番号の入力欄を作成する				</og:input></tr>
<tr><og:input type="url"			name="url"				> …… URLの入力欄を作成する					</og:input></tr>
<tr><og:input type="email"			name="email"			> …… メールアドレスの入力欄を作成する			</og:input></tr>
<tr><og:input type="datetime"		name="datetime"			> …… 協定世界時による日時の入力欄を作成する	</og:input></tr>
<tr><og:input type="date"			name="date"				> …… 日付の入力欄を作成する					</og:input></tr>
<tr><og:input type="month"			name="month"			> …… 月の入力欄を作成する						</og:input></tr>
<tr><og:input type="week"			name="week"				> …… 週の入力欄を作成する						</og:input></tr>
<tr><og:input type="time"			name="time"				> …… 時間の入力欄を作成する					</og:input></tr>
<tr><og:input type="datetime-local"	name="datetime-local"	> …… ローカル日時の入力欄を作成する			</og:input></tr>
<tr><og:input type="number"			name="number"			> …… 数値の入力欄を作成する					</og:input></tr>
<tr><og:input type="color"			name="color"			> …… 色の入力欄を作成する						</og:input></tr>
<tr><og:input type="range"			name="range"			> …… レンジ入力欄を作成する					</og:input></tr>
</table>

<table>
<tr><th>属性テスト</th>																	<th>説明</th></tr>
<tr><og:input 				name="autofocus"	autofocus="autofocus"						> …… 入力欄にカーソルを当てて自動フォーカスする	</og:input></tr>
<tr><og:input 				name="placeholder"	placeholder="テキストを入力してください"	> …… 入力欄に初期表示する内容を指定する			</og:input></tr>
<tr><og:input 				name="required"		required="required"							> …… 入力必須であることを示す						</og:input></tr>
<tr><og:input 				name="pattern"		pattern="[0-9]*"							> …… 正規表現で入力値のパターンを指定する ([0-9]*)	</og:input></tr>
<tr><og:input type="number" name="min_max"		min="2" max="10"							> …… 入力できる最小値と最大値を指定する (min="2" max="10")	</og:input></tr>
<tr><og:input type="number" name="step"			step="0.5"									> …… 入力欄で刻むステップ値を指定する (step="0.5") 	</og:input></tr>
<tr><og:input 				name="autocomplete"	autocomplete="on"	list="AAA"				> …… 入力候補を提示して入力内容を自動補完する      </og:input></tr>
<tr><og:input 				name="list"			lbl="BBB" list="BBB"						> …… 入力候補を提示して入力内容を自動補完する      </og:input></tr>
<tr><og:input 				name="list"			lbl="CCC" list="CCC"						> …… 入力候補を提示して入力内容を自動補完する      </og:input></tr>
<tr><og:select name="sel">
		<og:queryOption>
			select EMPNO,ENAME from EMP order by EMPNO
		</og:queryOption>
	</og:select></tr>
</table>

<table>
<tr><th colspan="2">属性テスト</th>							<th colspan="2">説明</th></tr>
<tr><td>progress</td><td><progress max="100" value="20" /></td>	<td>max="100" value="20"</td><td>タスク完了までの進行状況を示す</td></tr>
<tr><td>progress</td><td><progress max="100" /></td>				<td>max="100"			</td><td>タスク完了までの進行状況を示す</td></tr>
<tr><td>meter</td><td><meter value="25" min="0" max="100" low="20" high="80" optimum="50" /></td>
			<td>value="25" min="0" max="100" </td><td>規定範囲内の測定値を表す</td></tr>
<tr></tr>
</table>

<datalist id="AAA">
	<option value="ウィキペディア" />
	<option value="ウィルス対策" />
	<option value="ウィンドウズ" />
</datalist>

<!-- 互換モードの時、option の BODY 部だけ表示されてしまうので、div で隠す -->
<div style="display:none;">
<datalist id="BBB">
	<option value="1112"  >MARRY2</option>
	<option value="1114"  >JOHN</option>
	<option value="1115"  >SALA</option>
	<option value="1555"  >MIKE</option>
	<option value="7782"  >CLARK</option>
	<option value="7844"  >TURNER1B</option>
	<option value="7876"  >ADAMS</option>
	<option value="7900"  >JAMES</option>
</datalist>
</div>

<og:datalist id="CCC">
	<og:queryOption>
		select EMPNO,ENAME from EMP order by EMPNO
	</og:queryOption>
</og:datalist>

</form>

<br /><hr /><br />

<form onSubmit="return oneClick();" method="POST" enctype="multipart/form-data" action="upload.jsp" target="RESULT">
<table>
	<tr><og:input type="file"	name="multiple" 	optionAttributes="multiple"		> …… 複数の値を入力・選択できるようにする          </og:input></tr>
	<tr><td><og:submit  value="entry" lbl="UPLOAD" accesskey="U" /></td></tr>
</table>
</form>


<hr />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
