/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* ERR_CODE ( FUNCTION )                                                    */
/* Created : 2014/02/06 11:03:29                                            */
/****************************************************************************/
CREATE FUNCTION ERR_CODE 
FUNCTION ERR_CODE(
	IN_ERRCODE       IN VARCHAR2  )
RETURN VARCHAR2
/**********************************************************************/
/* エラーコードからエラーメッセージを得る                             */
/*  ERR_CODE( in_errcode )                                            */
/*                                                                    */
/*	 in_errcode in varchar2           エラーコード  (ORA-1401)など    */
/*                                                                    */
/*	指定されたエラーコードを元に、エラーメッセージを返します。        */
/**********************************************************************/
IS
	INDX     NUMBER ;
    ERRCODE  NUMBER ;
BEGIN
	INDX := INSTR(IN_ERRCODE,'-');

	IF INDX > 0 THEN ERRCODE := TO_NUMBER(SUBSTR( IN_ERRCODE,INDX ));
	ELSE ERRCODE := -TO_NUMBER(IN_ERRCODE);
	END IF;

	RETURN SQLERRM(ERRCODE);

END ERR_CODE;
/
