<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <TBLSYU    ><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:column       | //og:input        | //og:select    | //og:hidden | //og:textarea" />
    <xsl:apply-templates select="//og:columnEditor | //og:columnMarker | //og:link      | //og:popup" />
    <xsl:apply-templates select="//og:columnCheck  | //og:orderBy      | //og:readTable | //og:writeTable | //og:directTableInsert " />
	<xsl:apply-templates select="//*[@lbl] | //*[@lbls]" mode="lbl-in" />
  </xsl:template>

  <xsl:template match="og:column | og:input | og:select | og:hidden | og:textarea">
     <xsl:if test="@name">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"      /></TAGNAME>
           <FORM_TYPE   ><xsl:choose>
							<xsl:when test="@type"><xsl:value-of select="@type" /></xsl:when>
							<xsl:otherwise><xsl:value-of select="translate( local-name(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )" /></xsl:otherwise>
						</xsl:choose></FORM_TYPE>
           <FORM_NAME   ><xsl:value-of select="@name"       /></FORM_NAME>
           <FORM_VAL    ><xsl:value-of select="@value"      /></FORM_VAL>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal" /></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"        /></LBLCD>
           <MUST        ><xsl:value-of select="@must"       /></MUST>
           <VIEW_SIZE   ><xsl:value-of select="@size"       /></VIEW_SIZE>
           <MAX_SIZE    ><xsl:value-of select="@maxlength"  /></MAX_SIZE>
           <CODE_CLM    ><xsl:value-of select="@codeName"   /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"   /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"   /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"      /></ROLES>
           <TEXT_DATA   ><xsl:copy-of select="."            /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnEditor | og:columnMarker | og:link | og:popup">
     <xsl:if test="@column or @columns">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"      /></TAGNAME>
           <FORM_TYPE   >column</FORM_TYPE>
           <FORM_NAME   ><xsl:value-of select="@column"     />
						 <xsl:value-of select="@columns"    /></FORM_NAME>
           <FORM_VAL    ><xsl:value-of select="@value"      /></FORM_VAL>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal" /></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"        /></LBLCD>
           <MUST        ><xsl:value-of select="@must"       /></MUST>
           <VIEW_SIZE   ><xsl:value-of select="@size"       /></VIEW_SIZE>
           <MAX_SIZE    ><xsl:value-of select="@maxlength"  /></MAX_SIZE>
           <CODE_CLM    ><xsl:value-of select="@codeName"   /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"   /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"   /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"      /></ROLES>
           <TEXT_DATA   ><xsl:copy-of select="."            /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnCheck | og:directTableInsert | og:orderBy | og:readTable | og:writeTable">
     <xsl:if test="@columns">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"      /></TAGNAME>
           <FORM_TYPE   >columns</FORM_TYPE>
           <FORM_NAME   ><xsl:value-of select="@columns"    /></FORM_NAME>
           <FORM_VAL    ><xsl:value-of select="@value"      /></FORM_VAL>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal" /></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"        /></LBLCD>
           <MUST        ><xsl:value-of select="@must"       /></MUST>
           <VIEW_SIZE   ><xsl:value-of select="@size"       /></VIEW_SIZE>
           <MAX_SIZE    ><xsl:value-of select="@maxlength"  /></MAX_SIZE>
           <CODE_CLM    ><xsl:value-of select="@codeName"   /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"   /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"   /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"      /></ROLES>
           <TEXT_DATA   ><xsl:copy-of select="."            /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>

  <xsl:template match="*[@lbl] | *[@lbls]" mode="lbl-in" >
     <xsl:if test="string-length(@lbl) &gt; 0 or string-length(@lbls) &gt; 0">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"      /></TAGNAME>
           <FORM_TYPE   >lbl</FORM_TYPE>
           <FORM_NAME   ><xsl:value-of select="@lbl"        />
						 <xsl:value-of select="@lbls"       /></FORM_NAME>
           <FORM_VAL    ><xsl:value-of select="@value"      /></FORM_VAL>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal" /></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"        /></LBLCD>
           <MUST        ><xsl:value-of select="@must"       /></MUST>
           <VIEW_SIZE   ><xsl:value-of select="@size"       /></VIEW_SIZE>
           <MAX_SIZE    ><xsl:value-of select="@maxlength"  /></MAX_SIZE>
           <CODE_CLM    ><xsl:value-of select="@codeName"   /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"   /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"   /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"      /></ROLES>
           <TEXT_DATA   ><xsl:copy-of select="."            /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
