<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <TBLSYU    ><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:query | //og:update | //og:plsqlUpdate | //og:tableUpdate | //og:entryQuery" />
    <xsl:apply-templates select="//og:value[@command='SQL'] | //og:userInfo[@command='SQL'] | //og:tableUpdateParam" />
    <xsl:apply-templates select="//og:writeTableParam[@key='MergeSql']" />
    <xsl:apply-templates select="//og:queryOption" />
    <xsl:apply-templates select="//og:directWriteTable" />
    <xsl:apply-templates select="//og:tableFilter[@classId='DBSELECT']" />
    <xsl:apply-templates select="//og:chartDataset" />
    <xsl:apply-templates select="//og:dataCheck" />
    <xsl:apply-templates select="//og:columnEditor" />
    <xsl:apply-templates select="//og:hidden" />
  </xsl:template>

  <!-- テーブル名の取出し。ある文字間の文字列を抜き出す。評価の順番に注意 -->
  <xsl:template name="getTables">
    <xsl:param name="nd"/>
       <xsl:choose>
         <xsl:when test="contains($nd,'INSERT INTO ')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,'INSERT INTO ' ), ' ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,'UPDATE ')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,'UPDATE ' ), ' SET ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,' ON ')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,' FROM ' ), ' ON ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,' WHERE ')" >
           <!-- select と delete の両方が対象になる。 -->
           <xsl:value-of select="substring-before( substring-after( $nd ,' FROM ' ), ' WHERE ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,' GROUP BY ')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,' FROM ' ), ' GROUP BY ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,' UNION ')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,' FROM ' ), ' UNION ' )" />
         </xsl:when>
         <xsl:when test="contains($nd,'ORDER BY')" >
           <xsl:value-of select="substring-before( substring-after( $nd ,' FROM ' ), 'ORDER BY' )" />
         </xsl:when>
         <xsl:otherwise>
           <!-- select と delete の両方が対象になる。 -->
           <xsl:value-of select="substring-after( $nd ,' FROM ' )" />
         </xsl:otherwise>
       </xsl:choose>
  </xsl:template>

  <xsl:template match="og:query | og:update | og:plsqlUpdate | og:tableUpdate | og:entryQuery">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS>
         <xsl:value-of select="@names" />,<xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" />
       </CLMS>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:value[@command='SQL'] | og:userInfo[@command='SQL'] | og:tableUpdateParam">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS>
         <xsl:value-of select="@names" />,<xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" />
       </CLMS>
       <TABLE_NAMES>
         <xsl:if test="@table"><xsl:value-of select="@table" /></xsl:if>
         <xsl:if test="not(@table)">
           <xsl:call-template name="getTables">
             <xsl:with-param name="nd" select="$NODE"/>
           </xsl:call-template>
         </xsl:if>
       </TABLE_NAMES>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  ><xsl:value-of select="@sqlType"   /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:writeTableParam[@key='MergeSql']">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:queryOption">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()" /></TAGNAME>
       <CLMS>
         <xsl:value-of select="@names" />,<xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" />
       </CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   />
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:directWriteTable">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS>
         <xsl:value-of select="@names" />,<xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" />
       </CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:tableFilter[@classId='DBSELECT']">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:chartDataset">
	<xsl:if test="not(@useTableData='true')" >
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:dataCheck">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@sqlType"   /></SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:columnEditor">
	<xsl:if test="(@renderer='DBMENU' or @editor='DBMENU')" >
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:hidden">
    <xsl:variable name="NODE" select="normalize-space(translate( node(),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' ))" />
	<xsl:if test="contains($NODE,'SELECT ')" >
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="substring-before( substring-after( $NODE ,'SELECT ' ), ' FROM ' )" /></CLMS>
       <TABLE_NAMES>
         <xsl:call-template name="getTables">
           <xsl:with-param name="nd" select="$NODE"/>
         </xsl:call-template>
       </TABLE_NAMES>
       <TABLEID   />
       <DBID      />
       <SQL_TYPE  >SELECT</SQL_TYPE>
       <JSP_SCOPE />
       <SQL_TEXT  ><xsl:copy-of select="$NODE"       /></SQL_TEXT>
     </ROW>
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>
