<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head useGantt="true" headType="result" >

</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT06"
	title	= "ガントチャート"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "VIEW_DATE"
/>

<!-- 開始日付を、週単位に丸める処理を入れます。 -->
<og:value key="START_DATE" value="{@VIEW_DATE}" command="SETMEM" action="DAY_WEEK" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:value command="SQL" debug="{@debug}" >
		select MAX(TO_CHAR((TO_DATE(SUBSTRB(DYSTART,1,8))+DURATION),'YYYYMMDD')) AS DYMAX
		from GF64
		where FGJ  in  ('0','1')
		and   SUBSTRB(DYSTART,1,8) &gt;= SUBSTRB('{@VIEW_DATE}',1,8)
	<og:where startKey="and" >
		<og:and value = "WARN(DYSTART,DURATION,COMPLETE) &gt;= '{@WARN}'" />
		<og:and value = "PRJCODE    = '{@PRJCODE}'"    />
		<og:and value = "TASK_LEVEL = '{@TASK_LEVEL}'" />
		<og:and value = "COMPLETE {@COMPLETE}"         />
	</og:where>
</og:value>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- DYDIFF(A,B,C) で、A-B+C の日数計算をしています。マイナスは、0 です。 -->
<!-- VIEW_ZOOM(D,ZOOM) で、表示倍率を計算しています。期間の引き算は、画面表示上の計算です。 -->
<og:query command="{@command}" debug="{@debug}" >
		select PRJCODE,PRJ_NAME(PRJCODE) AS PRJ_NAME,TASK_ID,SEQ,NAME_JA AS TASK_NAME,
				MEETING,DYSTART,DURATION,COMPLETE,PRIORITY,
				TO_CHAR(TO_DATE(SUBSTRB(DYSTART,1,8),'YYYYMMDD')+DURATION-1,'YYYYMMDD') AS DYEND,
				VIEW_ZOOM(DYDIFF(DYSTART,'{@START_DATE}'),'{@VIEW_ZOOM}') AS DYSTR,
				VIEW_ZOOM(DYDIFF(TO_CHAR(TO_DATE(SUBSTRB(DYSTART,1,8),'YYYYMMDD')+DURATION,'YYYYMMDD') ,'{@START_DATE}'),'{@VIEW_ZOOM}') AS DYENDX,
				VIEW_ZOOM(DURATION,'{@VIEW_ZOOM}') AS DURA,
				VIEW_ZOOM(((DURATION-DYDIFF('{@START_DATE}',DYSTART)) * COMPLETE / 100.0),'{@VIEW_ZOOM}') AS SUMI,
				VIEW_ZOOM(((DURATION-DYDIFF('{@START_DATE}',DYSTART)) * ( 1.0 - COMPLETE / 100.0)),'{@VIEW_ZOOM}') AS MADA,
				MEETING || (CASE COMPLETE WHEN 100 THEN 1 ELSE 0 END) AS MCOMP,
				WARN(DYSTART,DURATION,COMPLETE) AS WARN,
				GET_RESOURCE(PRJCODE,TASK_ID) AS RESOURCE_NAMES
		from GF64
		where FGJ  in  ('0','1')
		and   SUBSTRB(DYSTART,1,8) &gt;= SUBSTRB('{@VIEW_DATE}',1,8)
	<og:where startKey="and" >
		<og:and value = "WARN(DYSTART,DURATION,COMPLETE) &gt;= '{@WARN}'" />
		<og:and value = "PRJCODE    = '{@PRJCODE}'"    />
		<og:and value = "TASK_LEVEL = '{@TASK_LEVEL}'" />
		<og:and value = "COMPLETE {@COMPLETE}"         />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "PRJCODE,SEQ" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="PRJ_NAME" gamenId="GANTT01" href="index.jsp" target="CONTENTS"
		keys="command,PRJCODE"
		vals="NEW,[PRJCODE]" />
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<img src="{@SYS.JSP}/image/ecblank.gif" alt=" " width="30px" height="10px"  />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="COMPLETE" /></strong></legend>
		<og:submit  value="complete"  lbl="COMPLETE" command="MODIFY" />
		<og:select name="COMPLETE_SET" lbl="COMPLETE" value="100">
			<og:option value="0"   lbl="0%" />
			<og:option value="20"  lbl="20%" />
			<og:option value="50"  lbl="50%" />
			<og:option value="80"  lbl="80%" />
			<og:option value="100" lbl="100%" />
		</og:select>
	</fieldset>
	<img src="{@SYS.JSP}/image/ecblank.gif" alt=" " width="30px" height="10px"  />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="MODIFY" /></strong></legend>
		<og:submit  value="nitteihenko" lbl="MODIFY" command="MODIFY" />
		<og:input name="DYSTART_ADD"  value="0" td="no" maxlength="3" />
		<og:input name="DURATION_ADD" value="0" td="no" maxlength="3" />
	</fieldset>
</og:writeCheck>
<!-- DB検索結果を表示させます。 -->

<script for="window" event="onload" type="text/javascript" >
	heightReset();
	ganttResize();
</script>

<table id="GantBody" border="0px" cellpadding="0px" cellspacing="0px" frame="box" rules="all" style="margin:0px;padding:0px;">
  <tr style="margin:0px;padding:0px;">
    <td valign="top" style="margin:0px;padding:0px;" >
      <div id="X1" style="overflow-x:hidden; overflow-y:hidden; overflow:auto;" >
        <jsp:directive.include file="viewX1.jsp" />
      </div>
    </td>
    <td  valign="top" style="margin:0px;padding:0px;">
      <div id="X2" style="position:absolute; overflow-x:auto; overflow-y:auto; overflow:auto;"
                   onscroll="document.all.X1.scrollTop = document.all.X2.scrollTop;" >
        <jsp:directive.include file="viewX2.jsp" />
      </div>
    </td>
  </tr>
</table>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
