<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2030"
	title	= "インデックス"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck	command   = "{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- マスタ存在チェック -->
<og:dataCheck command="{@command}" sqlType="{@sqlType}" execType="MODIFY|DELETE">
		select count(*) from GF06
		where SYSTEM_ID	= [SYSTEM_ID]
		and TBLSYU		= [TBLSYU] 
		and TABLE_NAME	= [TABLE_NAME]
		and INDEX_NAME	= [INDEX_NAME]
		and FGJ = '1'
</og:dataCheck>

<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- 通常登録処理 -->
	<og:tableUpdate command="{@command}" sqlType="{@sqlType}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "{@sqlType}"
			table		= "GF06"
			where		= "UNIQ=[UNIQ]"
		/>
	</og:tableUpdate>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
