/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.CodeData;

/**
 * データのコード情報を取り扱うSelectionクラスの、NULL時オブジェクトです。
 *
 * 以前は、Selection オブジェクトが null の場合に、NullPointerException で
 * いきなりエラーで停止していましたが、この、NULLセレクションを作成することで、
 * 取りあえず、どういう状況なのか、判るようにします。
 *
 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
 * @og.group 選択データ制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Selection_NULL extends Selection_KEYVAL {
	private final String	errMsg ;

	/**
	 * 引数にエラーメッセージを指定して作成する、コンストラクター
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param	strCode	エラーメッセージ文字列
	 */
	public Selection_NULL( final String strCode ) {
		super( null );
		errMsg = strCode ;
	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * 無条件で、エラーメッセージを返します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param   selectValue  選択されている値
	 * @param   seqFlag  シーケンスアクセス機能 [true:ON/false:OFF]
	 * @param   useShortLabel ラベル(短)をベースとしたオプション表示を行うかどうか(常にfalse)。
	 *
	 * @return  オプションタグ
	 * @see     #getOption( String, boolean )
	 */
	public String getOption( final String selectValue,final boolean seqFlag, final boolean useShortLabel ) {
		return errMsg + " value=[" + selectValue + "]";
	}

	/**
	 * 選択肢(value)に対するラベルを返します。
	 * 無条件で、エラーメッセージを返します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param	selectValue	選択肢の値
	 * @param	flag	短縮ラベルを [true:使用する/false:しない](常に false)
	 *
	 * @return  選択肢のラベル
	 * @see     #getValueLabel( String )
	 */
	public String getValueLabel( final String selectValue,final boolean flag ) {
		return errMsg + " value=[" + selectValue + "]";
	}
}
