/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;
import org.opengion.hayabusa.db.DBErrMsg;

public class Query_JDBCArrayCallable
extends AbstractQuery {
    private static final String VERSION = "5.7.2.3 (2014/01/31)";

    public void execute() {
        this.execute(null);
    }

    public void execute(String[] stringArray) {
        CallableStatement callableStatement = null;
        try {
            int n;
            Connection connection = this.getConnection();
            callableStatement = this.getConnection().prepareCall(this.getStatement());
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            Map<String, Class<?>> map = connection.getTypeMap();
            map.put("ERR_MSG", DBErrMsg.class);
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"ARG_ARRAY", (Connection)connection);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 2003, "ERR_MSG_ARRAY");
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    callableStatement.setObject(n + 3, (Object)StringUtil.rTrim((String)stringArray[n]));
                }
            }
            callableStatement.execute();
            n = callableStatement.getInt(1);
            this.setErrorCode(n);
            if (n > 0) {
                DBErrMsg dBErrMsg;
                ARRAY aRRAY = ((OracleCallableStatement)callableStatement).getARRAY(2);
                Object[] objectArray = (Object[])aRRAY.getArray();
                ErrorMessage errorMessage = new ErrorMessage("Query_JDBCArrayCallable Error!!");
                for (int i = 0; i < objectArray.length && (dBErrMsg = (DBErrMsg)objectArray[i]) != null; ++i) {
                    errorMessage.addMessage(dBErrMsg.getErrMsg());
                }
                this.setErrorMessage(errorMessage);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
                this.rollback();
                this.realClose();
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.stmtClose((Statement)callableStatement);
    }
}

