<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 'XX_' || A.CLM															-- ０は、カラム名
					|| ':' || A.NAME_JA													-- １は、値
					|| ':' || case when A.NAME_JA is null then '' else 'true' end		-- ２は、must
					|| ':' || A.USE_LENGTH												-- ３は、Length
					|| ':' || A.NAME_JA													-- ４は、Label
					|| ':' || A.EDITOR													-- ５は、Editor
					|| ':' || A.DBTYPE													-- ６は、DBType
					|| ':' || A.EDITOR_PARAM											-- ７は、EditParam
					as CLM,
				A.NAME_JA,B.LNAME,A.KBSAKU,A.SYSTEM_ID,A.EDITOR,A.USE_LENGTH,B.LANG,A.FGJ,'' as REQVAL
		from GEA03 A inner join GEA08 B
		on   A.SYSTEM_ID = B.SYSTEM_ID
		and  A.CLM       = B.CLM
		and  A.FGJ       = '1'
		and  B.FGJ       = '1'
and A.CODE_CLM is null
	<og:where startKey="and">
		<og:and value = "A.SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "B.LANG        =  '{@LANG}'"          />
		<og:and value = "A.CLM         like '{@CLM}%'"        />
		<og:and value = "A.NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "B.LNAME       like '{@LNAME}%'" />
		<og:and value = "A.KBSAKU      =    '{@KBSAKU}'"      />
		<og:and value = "A.EDITOR      =    '{@EDITOR}'"      />
		<og:and value = "A.DBTYPE      =    '{@DBTYPE}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.CLM,B.LANG" />
</og:query>

<og:columnEditor column="CLM" editor="ENTCLM" addNoValue="true" param="SAVE=TRUE,
QUERY=select a.clm,a.code,b.lname,b.sname
from GEA04 a,gea08 b
where a.system_id=b.system_id
and   a.clm || '.' || a.code = b.clm
and   a.system_id = 'GF'
and   'XX_' || a.clm = ?
and   a.fgj = '1'
and   b.fgj = '1'
and   b.lang = 'ja'
order by a.clm,a.seqno" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="ENTRY" />
	<og:submit  action="RESET" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	columnWritable = "CLM"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	numberType = "delete"
>
<og:thead rowspan="1"> <!-- --> </og:thead>

<og:tbody rowspan="1">
	<tr>
		<td class="S9">[SYSTEM_ID]</td>
		<td>[!CLM]</td>
		<td>[LANG]</td>
		<td>[EDITOR]</td>
		<td>[USE_LENGTH]</td>
		<td>[KBSAKU]</td>
		<td rowspan="3">[NAME_JA]</td>
	</tr>
	<tr>
		<td colspan="6">[CLM]</td>
	</tr>
	<tr>
		<td colspan="6">[LNAME]</td>
	</tr>
</og:tbody>

</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
