<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @FROM_DBID}" val2="POSTGRES">
  <og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select TABLENAME AS TABLE_NAME ,TABLENAME AS NAME_JA,
				0 AS JKENSU
		from pg_tables
		<og:where>
			<og:and value = "TABLENAME like '{@TABLE_NAME}%'" />
			<og:and value = "SCHEMANAME = 'public'" />
		</og:where>
		order by TABLENAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @FROM_DBID}" val2="ORACLE">
  <og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select A.TABLE_NAME,COALESCE(B.COMMENTS,A.TABLE_NAME) AS NAME_JA,
				COALESCE(A.NUM_ROWS,0) AS JKENSU
		from USER_TABLES A left outer join USER_TAB_COMMENTS B
				on A.TABLE_NAME = B.TABLE_NAME
		<og:where>
			<og:and value = "A.TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value = "INSTR(A.TABLE_NAME,'$') < 1" />
			<og:and value = "A.NUM_ROWS > {@ZERO}" />
			<og:and value = "B.COMMENTS {@NN}" />
		</og:where>
		order by A.TABLE_NAME
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @FROM_DBID}" val2="FIREBIRD">
  <og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select trim(RDB$RELATION_NAME) AS TABLE_NAME,trim(RDB$RELATION_NAME) AS NAME_JA,
				0 AS JKENSU
		from RDB$RELATIONS
		where RDB$SYSTEM_FLAG   = 0 
		and   RDB$RELATION_TYPE = 0 
		<og:where startKey="and">
			<og:and value = "RDB$RELATION_NAME like '{@TABLE_NAME}%'" />
		</og:where>
		order by RDB$RELATION_NAME
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD" val2="{@DBF.NAME @FROM_DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2010}" val1="{@DBF.NAME @FROM_DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:tableFilter classId="LABEL" scope="request" caseNN="{@SYSTEM_ID}"
		 keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},NAME_JA,NAME_JA" caseKey="NEW" caseVal="{@command}" />
