/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.validation;

import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.validation.EntityState;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class ValidationState
implements ValidationContext {
    private boolean fExtraChecking = true;
    private boolean fFacetChecking = true;
    private boolean fNormalize = true;
    private boolean fNamespaces = true;
    private EntityState fEntityState = null;
    private NamespaceContext fNamespaceContext = null;
    private SymbolTable fSymbolTable = null;
    private Locale fLocale = null;
    private final Hashtable fIdTable = new Hashtable();
    private final Hashtable fIdRefTable = new Hashtable();
    private static final Object fNullValue = new Object();

    public void setExtraChecking(boolean newValue) {
        this.fExtraChecking = newValue;
    }

    public void setFacetChecking(boolean newValue) {
        this.fFacetChecking = newValue;
    }

    public void setNormalizationRequired(boolean newValue) {
        this.fNormalize = newValue;
    }

    public void setUsingNamespaces(boolean newValue) {
        this.fNamespaces = newValue;
    }

    public void setEntityState(EntityState state) {
        this.fEntityState = state;
    }

    public void setNamespaceSupport(NamespaceContext namespace) {
        this.fNamespaceContext = namespace;
    }

    public void setSymbolTable(SymbolTable sTable) {
        this.fSymbolTable = sTable;
    }

    public String checkIDRefID() {
        Enumeration en = this.fIdRefTable.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (this.fIdTable.containsKey(key)) continue;
            return key;
        }
        return null;
    }

    public void reset() {
        this.fExtraChecking = true;
        this.fFacetChecking = true;
        this.fNamespaces = true;
        this.fIdTable.clear();
        this.fIdRefTable.clear();
        this.fEntityState = null;
        this.fNamespaceContext = null;
        this.fSymbolTable = null;
    }

    public void resetIDTables() {
        this.fIdTable.clear();
        this.fIdRefTable.clear();
    }

    public boolean needExtraChecking() {
        return this.fExtraChecking;
    }

    public boolean needFacetChecking() {
        return this.fFacetChecking;
    }

    public boolean needToNormalize() {
        return this.fNormalize;
    }

    public boolean useNamespaces() {
        return this.fNamespaces;
    }

    public boolean isEntityDeclared(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityDeclared(this.getSymbol(name));
        }
        return false;
    }

    public boolean isEntityUnparsed(String name) {
        if (this.fEntityState != null) {
            return this.fEntityState.isEntityUnparsed(this.getSymbol(name));
        }
        return false;
    }

    public boolean isIdDeclared(String name) {
        return this.fIdTable.containsKey(name);
    }

    public void addId(String name) {
        this.fIdTable.put(name, fNullValue);
    }

    public void addIdRef(String name) {
        this.fIdRefTable.put(name, fNullValue);
    }

    public String getSymbol(String symbol) {
        if (this.fSymbolTable != null) {
            return this.fSymbolTable.addSymbol(symbol);
        }
        return symbol.intern();
    }

    public String getURI(String prefix) {
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getURI(prefix);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }
}

