/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;

public class FBBlobOutputStream
extends OutputStream
implements FirebirdBlob.BlobOutputStream {
    private IscBlobHandle blobHandle;
    private FBBlob owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBBlobOutputStream(FBBlob owner) throws SQLException {
        Object syncObject;
        this.owner = owner;
        Object object = syncObject = owner.getSynchronizationObject();
        synchronized (object) {
            try {
                DatabaseParameterBuffer dpb = owner.gdsHelper.getDatabaseParameterBuffer();
                boolean useStreamBlobs = dpb.hasArgument(131);
                this.blobHandle = owner.gdsHelper.createBlob(!useStreamBlobs);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        if (owner.isNew) {
            owner.setBlobId(this.blobHandle.getBlobId());
        }
    }

    public void seek(int position, int seekMode) throws SQLException {
        try {
            this.owner.gdsHelper.seekBlob(this.blobHandle, position, seekMode);
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public long length() throws IOException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            try {
                byte[] info = this.owner.gdsHelper.getBlobInfo(this.blobHandle, new byte[]{6}, 20);
                return this.owner.interpretLength(info, 0);
            }
            catch (GDSException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (SQLException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("FBBlobOutputStream.write(int b) not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSegment(byte[] buf) throws GDSException {
        Object syncObject;
        Object object = syncObject = this.owner.getSynchronizationObject();
        synchronized (object) {
            this.owner.gdsHelper.putBlobSegment(this.blobHandle, buf);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (off == 0 && len == b.length && len < this.owner.bufferlength) {
                this.writeSegment(b);
            } else {
                int chunk = this.owner.bufferlength;
                int lastChunk = 0;
                byte[] buf = null;
                while (len > 0) {
                    if (len < chunk) {
                        chunk = len;
                    }
                    if (chunk != lastChunk) {
                        buf = new byte[chunk];
                        lastChunk = chunk;
                    }
                    System.arraycopy(b, off, buf, 0, chunk);
                    this.writeSegment(buf);
                    len -= chunk;
                    off += chunk;
                }
            }
        }
        catch (GDSException ge) {
            throw new IOException("Problem writing to FBBlobOutputStream: " + ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.blobHandle != null) {
            try {
                Object syncObject;
                Object object = syncObject = this.owner.getSynchronizationObject();
                synchronized (object) {
                    this.owner.gdsHelper.closeBlob(this.blobHandle);
                }
                this.owner.setBlobId(this.blobHandle.getBlobId());
            }
            catch (GDSException ge) {
                throw new IOException("could not close blob: " + ge);
            }
            this.blobHandle = null;
        }
    }
}

