/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBShortField
extends FBField {
    FBShortField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Short value = new Short(this.field.decodeShort(this.getFieldData()));
        if (value > 127 || value < -128) {
            throw (SQLException)FBShortField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        return this.field.decodeShort(this.getFieldData());
    }

    @Override
    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        return this.field.decodeShort(this.getFieldData());
    }

    @Override
    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        return this.field.decodeShort(this.getFieldData());
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        return this.field.decodeShort(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        return this.field.decodeShort(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return BigDecimal.valueOf(this.field.decodeShort(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        return this.field.decodeShort(this.getFieldData()) == 1;
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeShort(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setShort(Short.parseShort(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBShortField.createException(SHORT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setFieldData(this.field.encodeShort(value));
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setShort((short)(value ? 1 : 0));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (value > 32767.0f || value < -32768.0f) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 32767.0 || value < -32768.0) {
            throw (SQLException)FBShortField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw (SQLException)FBShortField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort((short)value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setShort(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(32767L)) > 0 || value.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
            throw (SQLException)FBShortField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setShort(value.shortValue());
    }
}

