/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.PrintWriter;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.ds.FBAbstractCommonDataSource;
import org.firebirdsql.ds.FBXAConnection;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBSQLException;

public class FBXADataSource
extends FBAbstractCommonDataSource
implements XADataSource,
Referenceable {
    private volatile transient FBDataSource internalDs;

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.internalDs == null) {
            this.initialize();
        }
        AbstractConnection connection = (AbstractConnection)this.internalDs.getConnection(user, password);
        return new FBXAConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.internalDs != null) {
                return;
            }
            try {
                GDSType gdsType = GDSType.getType(this.getType());
                if (gdsType == null) {
                    gdsType = GDSFactory.getDefaultGDSType();
                }
                FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(gdsType, this.getConnectionProperties());
                mcf.setDefaultConnectionManager(new XAConnectionManager());
                this.internalDs = (FBDataSource)mcf.createConnectionFactory();
                this.internalDs.setLogWriter(this.getLogWriter());
            }
            catch (ResourceException e) {
                throw new FBSQLException(e);
            }
        }
    }

    @Override
    protected void checkNotStarted() throws IllegalStateException {
        if (this.internalDs != null) {
            throw new IllegalStateException("DataSource already in use. Change of this property is not allowed");
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), DataSourceFactory.class.getName(), null);
        FBAbstractCommonDataSource.updateReference(ref, this);
        return ref;
    }

    private static class XAConnectionManager
    implements ConnectionManager,
    ConnectionEventListener {
        private static final long serialVersionUID = 2615167799315401379L;

        private XAConnectionManager() {
        }

        @Override
        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
            FBManagedConnection mc = (FBManagedConnection)((FBManagedConnectionFactory)mcf).createManagedConnection(null, cxRequestInfo);
            mc.setManagedEnvironment(true);
            mc.setConnectionSharing(false);
            mc.addConnectionEventListener(this);
            return mc.getConnection(null, cxRequestInfo);
        }

        @Override
        public void connectionClosed(ConnectionEvent ce) {
            block2: {
                PrintWriter externalLog = ((FBManagedConnection)ce.getSource()).getLogWriter();
                try {
                    ((FBManagedConnection)ce.getSource()).destroy();
                }
                catch (ResourceException e) {
                    if (externalLog == null) break block2;
                    externalLog.println("Exception closing unmanaged connection: " + e);
                }
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent ce) {
            block2: {
                PrintWriter externalLog = ((FBManagedConnection)ce.getSource()).getLogWriter();
                try {
                    ((FBManagedConnection)ce.getSource()).destroy();
                }
                catch (ResourceException e) {
                    if (externalLog == null) break block2;
                    externalLog.println("Exception closing unmanaged connection: " + e);
                }
            }
        }

        @Override
        public void localTransactionStarted(ConnectionEvent event) {
        }

        @Override
        public void localTransactionCommitted(ConnectionEvent event) {
        }

        @Override
        public void localTransactionRolledback(ConnectionEvent event) {
        }
    }
}

