/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FileLineModel;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class Process_GrepChangeExcel
extends AbstractProcess
implements ChainProcess {
    private String[] keyword = null;
    private String[] change = null;
    private boolean ignoreCase = false;
    private boolean isChange = true;
    private boolean display = false;
    private boolean debug = false;
    private int inCount = 0;
    private int findCount = 0;
    private int cngCount = 0;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_GrepChangeExcel() {
        super("org.opengion.fukurou.process.Process_GrepChangeExcel", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        String string = argument.getProparty("keywordFile");
        this.ignoreCase = argument.getProparty("ignoreCase", this.ignoreCase);
        this.isChange = argument.getProparty("isChange", this.isChange);
        String string2 = argument.getProparty("inEncode", System.getProperty("file.encoding"));
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        FileString fileString = new FileString();
        fileString.setFilename(string);
        fileString.setEncode(string2);
        String[] stringArray = fileString.getValue("\n");
        int n = stringArray.length;
        if (n == 0) {
            String string3 = "keywordFile \u306e\u5185\u5bb9\u304c \u8aad\u307f\u53d6\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + string + "]";
            throw new RuntimeException(string3);
        }
        this.println("keywordFile \u3092\u3001" + n + "\u4ef6\u8aad\u307f\u53d6\u308a\u307e\u3057\u305f\u3002");
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray[i];
            int n2 = string4.indexOf(9);
            if (n2 <= 0) continue;
            arrayList.add(string4.substring(0, n2).trim());
            String string5 = string4.substring(n2 + 1).trim();
            string5 = StringUtil.replace(string5, "\\n", CR);
            string5 = StringUtil.replace(string5, "\\t", "\t");
            arrayList2.add(string5);
        }
        this.keyword = arrayList.toArray(new String[arrayList.size()]);
        this.change = arrayList2.toArray(new String[arrayList2.size()]);
    }

    @Override
    public void end(boolean bl) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LineModel action(LineModel lineModel) {
        Object object;
        ++this.inCount;
        if (!(lineModel instanceof FileLineModel)) {
            String string = "\u30c7\u30fc\u30bf\u304c FileLineModel \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + CR;
            throw new RuntimeException(string);
        }
        FileLineModel fileLineModel = (FileLineModel)lineModel;
        File file = fileLineModel.getFile();
        if (!file.isFile()) {
            return lineModel;
        }
        boolean bl = false;
        FileInputStream fileInputStream = null;
        Workbook workbook = null;
        Sheet sheet = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string = null;
        try {
            fileInputStream = new FileInputStream(file);
            workbook = WorkbookFactory.create((InputStream)fileInputStream);
            for (n = 0; n < workbook.getNumberOfSheets(); ++n) {
                sheet = workbook.getSheetAt(n);
                string = sheet.getSheetName();
                if (this.display) {
                    this.println(file.getPath() + ":" + string);
                }
                int n4 = sheet.getFirstRowNum();
                int n5 = sheet.getLastRowNum();
                for (n2 = n4; n2 <= n5; ++n2) {
                    object = sheet.getRow(n2);
                    if (object == null) continue;
                    short s = object.getFirstCellNum();
                    int n6 = object.getLastCellNum();
                    for (n3 = (int)s; n3 <= n6; ++n3) {
                        String string2;
                        RichTextString richTextString;
                        int n7;
                        Cell cell = object.getCell(n3);
                        if (cell == null || (n7 = cell.getCellType()) != 1 || (richTextString = cell.getRichStringCellValue()) == null) continue;
                        String string3 = richTextString.getString();
                        if (this.debug) {
                            this.println("DEBUG:  [" + n2 + "," + n3 + "]=" + string3);
                        }
                        if ((string2 = this.changeString(string3)) == null) continue;
                        if (this.display) {
                            this.println("CHANGE: [" + n2 + "," + n3 + "]=" + string3 + "\u2192" + string2);
                        }
                        cell.setCellValue(string2);
                        bl = true;
                        ++this.findCount;
                    }
                }
                object = this.changeString(string);
                if (object == null) continue;
                if (this.display) {
                    this.println("  sheetName=" + string + "\u2192" + (String)object);
                }
                workbook.setSheetName(n, (String)object);
                bl = true;
                ++this.findCount;
            }
        }
        catch (IOException iOException) {
            try {
                String string4 = "\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + file.toString() + CR + "Sheet=[" + string + "],SheetNo=[" + n + "],rowNo=[" + n2 + "],cellNo=[" + n3 + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                throw new RuntimeException(string4, iOException);
                catch (InvalidFormatException invalidFormatException) {
                    String string5 = "\u8aad\u307f\u8fbc\u307f\u30d5\u30a1\u30a4\u30eb\u306e\u5f62\u5f0f\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + file.toString() + CR + "Sheet=[" + string + "],SheetNo=[" + n + "],rowNo=[" + n2 + "],cellNo=[" + n3 + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                    throw new RuntimeException(string5, invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(fileInputStream);
        if (this.isChange && bl) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                workbook.write((OutputStream)fileOutputStream);
                this.cngCount = this.findCount;
            }
            catch (IOException iOException) {
                try {
                    object = "\u30d5\u30a1\u30a4\u30eb\u3078\u66f8\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + file.toString() + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                    throw new RuntimeException((String)object, iOException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(fileOutputStream);
                    throw throwable;
                }
            }
            Closer.ioClose(fileOutputStream);
        }
        if (!bl) return null;
        LineModel lineModel2 = lineModel;
        return lineModel2;
    }

    public String changeString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = string;
        for (int i = 0; i < this.keyword.length; ++i) {
            string2 = string2.replaceAll(this.keyword[i], this.change[i]);
        }
        if (string.equals(string2) || this.ignoreCase && string.equalsIgnoreCase(string2)) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "Search File Count : " + this.inCount + CR + "\t" + "Key Find    Count : " + this.findCount + CR + "\t" + "Key Change  Count : " + this.cngCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_GrepChangeExcel \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel\u304b\u3089\u3001\u8a9e\u53e5\u3092").append(CR);
        stringBuilder.append("\u7f6e\u63db\u3059\u308b\u3001ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append("Process_GrepChange \u3068\u306e\u9055\u3044\u306f\u3001\u5165\u529b\u5143\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u3001\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306a\u306e\u304b\u3001").append(CR);
        stringBuilder.append("\u30cd\u30a4\u30c6\u30a3\u30d6EXCEL\u30d5\u30a1\u30a4\u30eb\u306a\u306e\u304b\u306e\u9055\u3044\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("keywordFile \u3088\u308a\u3001\u7f6e\u63db\u3059\u308b\u8a9e\u53e5\u3092\u542b\u3080\u30ad\u30fc\u3068\u5024\u306e\u30da\u30a2\u30fc(\u30bf\u30d6\u533a\u5207\u308a)\u3092\u8aad\u53d6\u308a\u3001").append(CR);
        stringBuilder.append("\u5bfe\u8c61\u3068\u3059\u308b\u8a9e\u53e5\u3092\u7f6e\u63db\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("keywordFile \u306b\u3001\u30bf\u30d6\u304c\u542b\u307e\u308c\u306a\u3044\u884c\u3084\u3001\u5148\u982d\u306b\u30bf\u30d6\u304c\u5b58\u5728\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001").append(CR);
        stringBuilder.append("\u305d\u306e\u884c\u3092\u8aad\u307f\u98db\u3070\u3057\u307e\u3059\u3002\u307e\u305f\u3001\u533a\u5207\u308a\u30bf\u30d6\u306f\u4f55\u500b\u5b58\u5728\u3057\u3066\u3082\u69cb\u3044\u307e\u305b\u3093\u3002").append(CR);
        stringBuilder.append("\u305f\u3060\u3057\u3001\u30bf\u30d6\u3067\u533a\u5207\u3063\u305f\u524d(\u30ad\u30fc)\u3068\u5f8c\u308d(\u5024)\u306f\u3001trim() \u3055\u308c\u307e\u3059\u306e\u3067\u3001\u30b9\u30da\u30fc\u30b9").append(CR);
        stringBuilder.append("\u304c\u524d\u5f8c\u306b\u5b58\u5728\u3057\u3066\u3044\u308b\u5834\u5408\u306f\u3001\u3054\u6ce8\u610f\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u7f6e\u63db\u6587\u5b57(\u5024)\u306f\u3001\t \u3068 \n \u306e\u7279\u6b8a\u6587\u5b57\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u3053\u306e GrepChangeExcel \u3067\u306f\u3001\u8a9e\u53e5\u306b\u3001\u6b63\u898f\u8868\u73fe\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002\u6b63\u898f\u8868\u73fe\u306e\u30ad\u30fc\u30ef\u30fc\u30c9").append(CR);
        stringBuilder.append("\u3084\u6587\u5b57\u5217\u3092\u8907\u6570\u884c\u306e\u6587\u5b57\u5217\u3068\u7f6e\u304d\u63db\u3048\u308b\u5834\u5408\u306f\u3001Process_Grep \u3092\u4f7f\u7528\u3057\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3067\u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel \u306e\u30d5\u30a1\u30a4\u30eb\u306b\u5bfe\u3057\u3066\u3001").append(CR);
        stringBuilder.append("\u7f6e\u304d\u63db\u3048\u305f\u7d50\u679c\u3082\u3001\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u306b\u30bb\u30fc\u30d6\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u5143\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u305f\u3044\u5834\u5408\u306f\u3001\u4e88\u3081\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3092\u53d6\u5f97\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append("-inEncode \u306f\u3001keywordFile\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u6307\u5b9a\u306b\u306a\u308a\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u521d\u671f\u5024\u306f\u3001\u4e92\u63db\u6027\u3092\u6301\u3064\u305f\u3081\u3001System.getProperty(\"file.encoding\") \u3067\u3059\u304c\u3001").append(CR);
        stringBuilder.append("\u660e\u793a\u7684\u306b UTF-8 \u306a\u3069\u3092\u6307\u5b9a\u3057\u3066\u7d71\u4e00\u3057\u3066\u304a\u3044\u305f\u307b\u3046\u304c\u826f\u3044\u3067\u3057\u3087\u3046\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\u30d7\u30ed\u30bb\u30b9\u3067\u306f\u3001Name \u5c5e\u6027\u3068\u3057\u3066\u3001\u300eFile\u300f\u3092\u6301\u3061\u3001\u5024\u306f\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8").append(CR);
        stringBuilder.append("\u3067\u3042\u308b\u3001Process_FileSearch \u3092\u4f7f\u7528\u3059\u308b\u306e\u304c\u3001\u4fbf\u5229\u3067\u3059\u3002\u305d\u308c\u4ee5\u5916\u306e\u30af\u30e9\u30b9\u3092").append(CR);
        stringBuilder.append("\u4f7f\u7528\u3059\u308b\u5834\u5408\u3067\u3082\u3001Name\u5c5e\u6027\u3068\u3001File \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6301\u3064 LineModel \u3092\u53d7\u3051\u6e21\u3057").append(CR);
        stringBuilder.append("\u3067\u304d\u308c\u3070\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_GrepChangeExcel().usage());
    }

    static {
        mustProparty.put("keywordFile", "\u7f6e\u63db\u3059\u308b\u8a9e\u53e5\u3092\u542b\u3080\u30ad\u30fc\u3068\u5024\u306e\u30da\u30a2\u30fc(\u30bf\u30d6\u533a\u5207\u308a)(\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("ignoreCase", "\u691c\u7d22\u6642\u306b\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3057\u306a\u3044(true)\u304b\u3069\u3046\u304b\u3002" + CR + "(\u521d\u671f\u5024:\u533a\u5225\u3059\u308b[false])");
        usableProparty.put("isChange", "\u7f6e\u63db\u51e6\u7406\u3092\u5b9f\u65bd\u3059\u308b(true)\u304b\u3069\u3046\u304b" + CR + "(\u521d\u671f\u5024:\u7f6e\u63db\u3059\u308b[true])");
        usableProparty.put("inEncode", "keywordFile\u306e\u30a8\u30f3\u30b3\u30fc\u30c9");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u7528\u306b\u5b9f\u884c\u5185\u5bb9\u3092\u8868\u793a\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

