/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import org.opengion.fukurou.mail.MailMessage;
import org.opengion.fukurou.mail.MailRX;
import org.opengion.fukurou.mail.MailReceiveListener;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;

public class MailReceiver {
    private static Logger logger = Logger.getLogger("org.opengion.fukurou.fukurou.mail.MailReceiver");
    private static final String CR = System.getProperty("line.separator");
    public static final int MAX_ROW_COUNT = 100;
    public static final boolean DELETE_MESSAGE = false;
    public static final String PROTOCOL = "pop3";
    public static final int PORT = -1;
    private Argument argment = null;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public void start(String[] stringArray) throws MessagingException {
        logger.fine("\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u89e3\u6790\u3001\u53d6\u5f97");
        this.argment = new Argument("org.opengion.fukurou.fukurou.mail.MailReceiver");
        this.argment.setMustProparty(mustProparty);
        this.argment.setUsableProparty(usableProparty);
        this.argment.setArgument(stringArray);
        if (this.argment.getProparty("help", false)) {
            System.out.println(this.argment.toString());
            return;
        }
        logger.fine("\u51e6\u7406\u306b\u5fc5\u8981\u306a\u5404\u7a2e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u53d6\u5f97\u3057\u307e\u3059\u3002");
        MailRX mailRX = new MailRX();
        mailRX.setHost(this.argment.getProparty("host"));
        mailRX.setUser(this.argment.getProparty("user"));
        mailRX.setPasswd(this.argment.getProparty("passwd"));
        mailRX.setProtocol(this.argment.getProparty("protocol", PROTOCOL));
        mailRX.setPort(this.argment.getProparty("port", -1));
        mailRX.setDelete(this.argment.getProparty("delete", false));
        mailRX.setMaxRowCount(this.argment.getProparty("maxRowCount", 100));
        logger.fine("\u6307\u5b9a\u306e\u6761\u4ef6\u306b\u30de\u30c3\u30c1\u3057\u305f\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u307f\u629c\u304d\u51fa\u3059\u6761\u4ef6\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        HybsEntry[] hybsEntryArray = this.argment.getEntrys("match_");
        for (int i = 0; i < hybsEntryArray.length; ++i) {
            mailRX.addMatchTerm(hybsEntryArray[i]);
        }
        logger.fine("\u30ea\u30b9\u30ca\u30fc\u3092\u8a2d\u5b9a\u3057\u3066\u3001\u53d7\u4fe1\u30e1\u30fc\u30eb\u3092\u4e00\u4ef6\u305a\u3064\u51e6\u7406\u3057\u307e\u3059\u3002");
        String string = this.argment.getProparty("mailSaveDir");
        String string2 = this.argment.getProparty("fileSaveDir");
        boolean bl = this.argment.getProparty("useMsgId", false);
        ReceiveListener receiveListener = new ReceiveListener(string, string2, bl);
        mailRX.setMailReceiveListener(receiveListener);
        mailRX.start();
    }

    public static void main(String[] stringArray) {
        MailReceiver mailReceiver = new MailReceiver();
        try {
            logger.info("\u30e1\u30fc\u30eb\u53d7\u4fe1\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059  ---------------------------------------------");
            mailReceiver.start(stringArray);
            logger.info("\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Throwable throwable) {
            String string = "\u30e1\u30fc\u30eb\u53d7\u4fe1\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 " + CR + mailReceiver.argment + CR + throwable.getMessage();
            LogWriter.log(string);
            logger.log(Level.SEVERE, string, throwable);
            throw new RuntimeException(string, throwable);
        }
    }

    static {
        mustProparty.put("host", "\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u30fc(\u5fc5\u9808)");
        mustProparty.put("user", "\u30e1\u30fc\u30eb\u3092\u53d6\u5f97\u3059\u308b\u30ed\u30b0\u30a4\u30f3\u30e6\u30fc\u30b6\u30fc(\u5fc5\u9808)");
        mustProparty.put("passwd", "\u30e1\u30fc\u30eb\u3092\u53d6\u5f97\u3059\u308b\u30ed\u30b0\u30a4\u30f3\u30d1\u30b9\u30ef\u30fc\u30c9(\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("protocol", "\u53d7\u4fe1\u30b5\u30fc\u30d0\u30fc\u306e\u30d7\u30ed\u30c8\u30b3\u30eb(imap,pop3)\u3092\u6307\u5b9a(\u521d\u671f\u5024:pop3)");
        usableProparty.put("port", "\u53d7\u4fe1\u30b5\u30fc\u30d0\u30fc\u306e\u30dd\u30fc\u30c8\u3092\u6307\u5b9a(\u521d\u671f\u5024:-1)");
        usableProparty.put("mailSaveDir", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u3092\u30bb\u30fc\u30d6\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3002" + CR + "\u6307\u5b9a\u304c\u306a\u3044\u5834\u5408\u306f\u3001\u6a19\u6e96\u51fa\u529b\u3078\u51fa\u529b\u3059\u308b\u3002");
        usableProparty.put("fileSaveDir", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u3092\u30bb\u30fc\u30d6\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3002" + CR + "\u6307\u5b9a\u304c\u306a\u3044\u5834\u5408\u306f\u629c\u304d\u51fa\u3055\u306a\u3044\u3002");
        usableProparty.put("useMsgId", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u3092\u30bb\u30fc\u30d6\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u3001" + CR + "MesssageId\u30d5\u30a9\u30eb\u30c0\u3092\u500b\u5225\u306b\u5272\u308a\u5f53\u3066\u308b\u304b\u3069\u3046\u304b\u3002");
        usableProparty.put("maxRowCount", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u306e\u6700\u5927\u53d6\u308a\u8fbc\u307f\u4ef6\u6570(\u521d\u671f\u5024:100)(0:[\u7121\u5236\u9650])");
        usableProparty.put("match_Subject", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u306eSubject\u3092\u9078\u629e\u3059\u308b\u6761\u4ef6");
        usableProparty.put("match_Body", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u306eBody\u3092\u9078\u629e\u3059\u308b\u6761\u4ef6");
        usableProparty.put("match_From", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u306eFrom\u3092\u9078\u629e\u3059\u308b\u6761\u4ef6");
        usableProparty.put("match_", "\u53d7\u4fe1\u30e1\u30fc\u30eb\u306e\u30d8\u30c3\u30c0\u30fc\u90e8\u306e\u30ad\u30fcXXXX\u3092\u9078\u629e\u3059\u308b\u6761\u4ef6");
        usableProparty.put("delete", "\u691c\u7d22\u5f8c\u3001\u30e1\u30fc\u30eb\u3092\u30b5\u30fc\u30d0\u30fc\u304b\u3089\u524a\u9664\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u3001" + CR + "true/false\u3067\u6307\u5b9a(\u521d\u671f\u5024:false)");
        usableProparty.put("help", "\u4f7f\u7528\u65b9\u6cd5\u3092\u51fa\u529b\u3057\u3066\u3001\u7d42\u4e86\u3057\u307e\u3059\u3002");
    }

    private static class ReceiveListener
    implements MailReceiveListener {
        private final String mailSaveDir;
        private final String fileSaveDir;
        private final boolean useMsgId;
        private int counter = 0;

        public ReceiveListener(String string, String string2, boolean bl) {
            this.mailSaveDir = string;
            this.fileSaveDir = string2;
            this.useMsgId = bl;
        }

        @Override
        public boolean receive(MailMessage mailMessage) {
            String string = "[" + this.counter++ + "]" + mailMessage.getMessageID() + " \u53d7\u4fe1\u4e2d";
            System.out.println(string);
            if (this.mailSaveDir != null) {
                mailMessage.saveMessage(this.mailSaveDir);
            } else {
                System.out.println(mailMessage.getSubject());
                System.out.println(mailMessage.getContent());
            }
            if (this.fileSaveDir != null) {
                mailMessage.saveAttachFiles(this.fileSaveDir, this.useMsgId);
            }
            return true;
        }
    }
}

