/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipFile;
import org.opengion.fukurou.util.LogWriter;

public final class Closer {
    private static final String CR = System.getProperty("line.separator");

    private Closer() {
    }

    public static boolean ioClose(Closeable closeable) {
        boolean bl = true;
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
            String string = "\u30b9\u30c8\u30ea\u30fc\u30e0 close \u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + iOException.getMessage() + CR + closeable.toString();
            LogWriter.log(string);
            LogWriter.log(iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR + closeable.toString();
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean commit(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            String string = "Connection \u3092 commit \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            LogWriter.log(string);
            LogWriter.log(sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean rollback(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            String string = "Connection \u3092 rollback \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            LogWriter.log(string);
            LogWriter.log(sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean connClose(Connection connection) {
        boolean bl = true;
        try {
            if (connection != null && !connection.isClosed()) {
                connection.commit();
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            String string = "Connection \u3092 rollback \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            LogWriter.log(string);
            LogWriter.log(sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean stmtClose(Statement statement) {
        boolean bl = true;
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            String string = "Statement \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            LogWriter.log(string);
            LogWriter.log(sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean resultClose(ResultSet resultSet) {
        boolean bl = true;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            String string = "ResultSet \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + sQLException.getMessage() + ":" + sQLException.getSQLState() + CR;
            LogWriter.log(string);
            LogWriter.log(sQLException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }

    public static boolean zipClose(ZipFile zipFile) {
        boolean bl = true;
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            String string = "ZipFile/JarFile \u3092 close \u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + iOException.getMessage() + ":" + zipFile.getName() + CR;
            LogWriter.log(string);
            LogWriter.log(iOException);
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            String string = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + runtimeException.getMessage() + CR;
            LogWriter.log(string);
            LogWriter.log(runtimeException);
        }
        return bl;
    }
}

