/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNodeType;

public class OGNode {
    public static final String CR = System.getProperty("line.separator");
    private final List<OGNode> nodes = new ArrayList<OGNode>();
    private final String text;
    private OGNodeType nodeType;
    private OGNode parentNode = null;

    public OGNode() {
        this.text = null;
        this.nodeType = OGNodeType.List;
    }

    public OGNode(String string) {
        this.text = string;
        this.nodeType = this.text != null ? OGNodeType.Text : OGNodeType.List;
    }

    public OGNode addNode(String string) {
        if (string != null) {
            if (this.nodeType == OGNodeType.Text) {
                String string2 = "\u4e00\u65e6\u3001\u30c6\u30ad\u30b9\u30c8\u30ce\u30fc\u30c9\u3068\u3057\u3066\u4f5c\u6210\u3057\u305f\u30ce\u30fc\u30c9\u306b\u306f\u3001\u30ce\u30fc\u30c9\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002";
                throw new RuntimeException(string2);
            }
            OGNode oGNode = new OGNode(string);
            oGNode.parentNode = this;
            this.nodes.add(oGNode);
        }
        return this;
    }

    public OGNode addNode(OGNode oGNode) {
        if (oGNode != null) {
            if (this.nodeType == OGNodeType.Text) {
                String string = "\u4e00\u65e6\u3001\u30c6\u30ad\u30b9\u30c8\u30ce\u30fc\u30c9\u3068\u3057\u3066\u4f5c\u6210\u3057\u305f\u30ce\u30fc\u30c9\u306b\u306f\u3001\u30ce\u30fc\u30c9\u3092\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002";
                throw new RuntimeException(string);
            }
            oGNode.parentNode = this;
            this.nodes.add(oGNode);
        }
        return this;
    }

    public int nodeSize() {
        return this.nodes.size();
    }

    public OGNode getNode(int n) {
        return this.nodes.get(n);
    }

    public void setNode(int n, OGNode oGNode) {
        this.nodes.set(n, oGNode);
    }

    public OGNode getParentNode() {
        return this.parentNode;
    }

    public int getParentCount() {
        int n = 0;
        for (OGNode oGNode = this.getParentNode(); oGNode != null; oGNode = oGNode.getParentNode()) {
            ++n;
        }
        return n;
    }

    public OGNode removeNode(int n) {
        return this.nodes.remove(n);
    }

    public void clearNode() {
        this.nodes.clear();
    }

    public void changeNode(OGNode oGNode, OGNode oGNode2) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            OGNode oGNode3 = this.nodes.get(i);
            if (oGNode3.equals(oGNode)) {
                this.nodes.set(i, oGNode2);
                continue;
            }
            oGNode3.changeNode(oGNode, oGNode2);
        }
    }

    public List<OGElement> getChildElementList() {
        ArrayList<OGElement> arrayList = new ArrayList<OGElement>();
        for (OGNode oGNode : this.nodes) {
            if (oGNode.nodeType != OGNodeType.Element) continue;
            arrayList.add((OGElement)oGNode);
        }
        return arrayList;
    }

    public List<OGElement> getElementList(String string) {
        ArrayList<OGElement> arrayList = new ArrayList<OGElement>();
        if (string != null) {
            for (OGNode oGNode : this.nodes) {
                if (oGNode.nodeType != OGNodeType.Element) continue;
                OGElement oGElement = (OGElement)oGNode;
                if (string.equals(oGElement.getTagName())) {
                    arrayList.add(oGElement);
                }
                arrayList.addAll(oGElement.getElementList(string));
            }
        }
        return arrayList;
    }

    public void setNodeType(OGNodeType oGNodeType) {
        if (oGNodeType != null) {
            if (oGNodeType != OGNodeType.Text && this.nodeType == OGNodeType.Text) {
                OGNode oGNode = new OGNode(this.text);
                oGNode.parentNode = this;
                this.nodes.add(oGNode);
            }
            this.nodeType = oGNodeType;
        }
    }

    public OGNodeType getNodeType() {
        return this.nodeType;
    }

    public String getText(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nodeType == OGNodeType.Text) {
            stringBuilder.append(this.text);
        } else {
            for (OGNode oGNode : this.nodes) {
                stringBuilder.append(oGNode.getText(n));
            }
        }
        Object object = stringBuilder.toString();
        switch (this.nodeType) {
            case Comment: {
                object = "<!-- " + (String)object + " -->";
                break;
            }
            case Cdata: {
                object = "<![CDATA[ " + (String)object + " ]]>";
                break;
            }
        }
        return object;
    }

    public String toString() {
        return this.getText(-10);
    }
}

