/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.util.LogWriter;

public class ExcelLayoutData
implements Comparable<ExcelLayoutData> {
    private final int edbn;
    private final String key;
    private final String clm;
    private final int rowNo;
    private final short colNo;
    private final String uniqKey;
    private final int hashcode;

    public ExcelLayoutData(String string, int n, short s) {
        this.key = string.trim();
        this.rowNo = n;
        this.colNo = s;
        if (!this.key.startsWith("{@") || !this.key.endsWith("}")) {
            String string2 = "\u6307\u5b9a\u306e\u30bb\u30eb\u306e\u30ab\u30e9\u30e0\u5b9a\u7fa9\u304c\u4e0d\u6b63\u3067\u3059\u3002row,col=[" + n + "," + s + "] , key=[" + this.key + "]";
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.key.substring(2, this.key.length() - 1);
        int n2 = string3.lastIndexOf(95);
        int n3 = -1;
        if (n2 > 0) {
            try {
                n3 = Integer.parseInt(string3.substring(n2 + 1));
                string3 = string3.substring(0, n2);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = "\u30d8\u30c3\u30c0\u30fc\u306b\u30a2\u30f3\u30c0\u30fc\u30d0\u30fc\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string3 + "]";
                LogWriter.log((String)string4);
            }
        }
        this.edbn = n3;
        this.clm = string3;
        this.uniqKey = this.edbn < 0 ? this.clm + ":[" + n + "," + s + "]" : this.clm + "_" + this.edbn + ":[" + n + "," + s + "]";
        this.hashcode = this.uniqKey.hashCode();
    }

    private ExcelLayoutData(ExcelLayoutData excelLayoutData, int n, int n2) {
        this.key = excelLayoutData.key;
        this.rowNo = n;
        this.colNo = excelLayoutData.colNo;
        this.edbn = n2;
        this.clm = excelLayoutData.clm;
        this.uniqKey = this.edbn < 0 ? this.clm + ":[" + this.rowNo + "," + this.colNo + "]" : this.clm + "_" + this.edbn + ":[" + this.rowNo + "," + this.colNo + "]";
        this.hashcode = this.uniqKey.hashCode();
    }

    public int getEdbn() {
        return this.edbn;
    }

    public String getClm() {
        return this.clm;
    }

    public int getRowNo() {
        return this.rowNo;
    }

    public short getColNo() {
        return this.colNo;
    }

    public String getKey() {
        return this.key;
    }

    public ExcelLayoutData copy(int n, int n2) {
        return new ExcelLayoutData(this, n, n2);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (object instanceof ExcelLayoutData) {
            return this.uniqKey.equals(((ExcelLayoutData)object).uniqKey);
        }
        return false;
    }

    @Override
    public int compareTo(ExcelLayoutData excelLayoutData) {
        if (this.uniqKey.equals(excelLayoutData.uniqKey)) {
            return 0;
        }
        if (this.edbn != excelLayoutData.edbn) {
            return this.edbn - excelLayoutData.edbn;
        }
        if (!this.clm.equals(excelLayoutData.clm)) {
            return this.clm.compareTo(excelLayoutData.clm);
        }
        if (this.rowNo != excelLayoutData.rowNo) {
            return this.rowNo - excelLayoutData.rowNo;
        }
        return this.colNo - excelLayoutData.colNo;
    }

    public String toString() {
        return this.uniqKey;
    }
}

