/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.HashMap;
import java.util.Map;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThread;

public final class ExecThreadManager {
    private static final Map<String, ExecThread> pool = new HashMap<String, ExecThread>();
    private static boolean debug = false;

    private ExecThreadManager() {
    }

    public static void insertQueue(ExecQueue execQueue) {
        ExecThread execThread = ExecThreadManager.getExecThread(execQueue.getThreadId());
        execThread.stackQueue(execQueue);
    }

    public static void insertQueueOnNewThread(ExecQueue execQueue) {
        ExecThread execThread = new ExecThread(execQueue.getThreadId(), debug);
        execThread.start();
        System.out.println("[INFO]THREAD CREATED:THREAD-ID=" + execQueue.getThreadId());
        execThread.stackQueue(execQueue);
        execThread.finishAfterExec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecThread getExecThread(String string) {
        ExecThread execThread = null;
        Map<String, ExecThread> map = pool;
        synchronized (map) {
            execThread = pool.get(string);
            if (execThread != null && !execThread.isAlive()) {
                pool.remove(string);
                execThread = null;
            }
            if (execThread == null) {
                execThread = new ExecThread(string, debug);
                execThread.start();
                System.out.println("[INFO]THREAD CREATED:THREAD-ID=" + string);
                pool.put(string, execThread);
            }
        }
        return execThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishAllThreads() {
        Map<String, ExecThread> map = pool;
        synchronized (map) {
            for (ExecThread execThread : pool.values()) {
                execThread.finish();
            }
            pool.clear();
            System.out.println("[INFO]ALL THREADS FINISHED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishThread(String string) {
        Map<String, ExecThread> map = pool;
        synchronized (map) {
            ExecThread execThread = pool.remove(string);
            if (execThread != null) {
                execThread.finish();
                System.out.println("[INFO]THREAD CREATED:THREAD-ID=" + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getThreadInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, ExecThread> map = pool;
        synchronized (map) {
            for (Map.Entry<String, ExecThread> entry : pool.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return hashMap;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }
}

