<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0018"
	title    = "データロール"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_ROLES" value="ROLE" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_ROLES" value="ROLES" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,DROLE,CLM,CVALUE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select '1' as WRITABLE,A.DROLE,A.CLM,A.CVALUE,A.VALCDTN,A.SYSTEM_ID,A.FGJ,A.UNIQ
		from GEA06 A
	<og:where>
		<og:and value = "A.FGJ			=	'{@FGJ}'"		/>
		<og:and value = "A.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A.DROLE		like '{@DROLE}%'"	/>
		<og:and value = "A.CLM			like '{@CLM}%'"		/>
		<og:and value = "A.CVALUE		like '{@CVALUE}%'"	/>
		<og:and value = "A.VALCDTN		like '{@VALCDTN}%'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.DROLE,A.CLM,A.CVALUE" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,CLM,CVALUE,VALCDTN" must="true" />
<og:columnEditor column="DROLE" must="true" editor="INDBMENU" renderer="DBMENU">
	select {@C_ROLES}, {@C_ROLES}||':'||NMROLE
	from GEA05
	where SYSTEM_ID = '{@SYSTEM_ID}'
	and KBROLE = '2'
	and FGJ = '1'
	order by {@C_ROLES}
</og:columnEditor>

<og:viewLink command="{@command}">
	<og:link column="DROLE" gamenId="GE0017" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,ROLES,KBROLE,FGJ"
		vals="NEW,[SYSTEM_ID],[DROLE],2,1" />
</og:viewLink>	

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"SYSTEM_ID,DROLE,CLM,CVALUE"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="Z"
		keys="columnWritable,logicalDelete" vals="null,true" />
	<og:submit  value="update"   lbl="DELETE_PH" command="DELETE" roles="DEL"
		keys="columnWritable" vals="null" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GEA06" /></strong></legend>
		<og:column  name="SYSTEM_ID" useRequestValue="false" must="true" td="no" />
		<og:submit  value="update" lbl="COPY" command="COPY"
			keys="noWritable,sysins" vals="null,true" />
	</fieldset>

	<og:link gamenId="GE0019" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,KBROLE"
		vals="NEW,{@SYSTEM_ID},2">[{@LBL.GE0019}]</og:link>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
