<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2020"
	title	= "テーブルカラム"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select	A.TBLSYU,A.TABLE_NAME,B.NAME_JA AS TABLENAME_JA,A.SEQNO,A.CLM,A.NAME_JA,A.CLS_NAME,
				A.USE_LENGTH,A.DATA_DEFAULT,A.NOT_NULL,A.FGCOM,'' as JKENSU,'' as SKENSU,
				A.RENDERER,A.EDITOR,A.DBTYPE,A.BIKO,A.SYSTEM_ID,A.FGJ,A.UNIQ
		from GF05 A LEFT OUTER JOIN GF02 B
					ON	A.SYSTEM_ID		= B.SYSTEM_ID
					AND	A.TBLSYU		= B.TBLSYU
					AND	A.TABLE_NAME	= B.TABLE_NAME
					AND	B.FGJ			= '1'
	<og:where>
		<og:and value = "A.FGJ         in  ('0','1')"			/>
		<og:and value = "A.SYSTEM_ID   =    '{@SYSTEM_ID}'"	/>
		<og:and value = "A.TBLSYU      =    '{@TBLSYU}'"		/>
		<og:and value = "A.TABLE_NAME  like '{@TABLE_NAME}%'"	/>
		<og:and value = "A.CLM         like '{@CLM}%'"			/>
		<og:and value = "A.NAME_JA     like '{@NAME_JA}%'"		/>
		<og:and value = "A.FGCOM       =    '{@FGCOM}'"		/>
		<og:and value = "A.CLS_NAME    =    '{@CLS_NAME}'"		/>
		<og:and value = "A.RENDERER    =    '{@RENDERER}'"		/>
		<og:and value = "A.EDITOR      =    '{@EDITOR}'"		/>
		<og:and value = "A.DBTYPE      =    '{@DBTYPE}'"		/>
		<og:and value = "A.NOT_NULL    =    '{@NOT_NULL}'"		/>
		<og:and value = "A.USE_LENGTH  =    '{@USE_LENGTH}'"	/>
		<og:and value = "A.BIKO        like '{@BIKO}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.TBLSYU,A.TABLE_NAME,A.SEQNO" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="TABLE_NAME" gamenId="GF2030" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="10"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU,FGJ"
		vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU],1" />
	<og:link column="CLM" gamenId="GF2040" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="10"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU,FGJ"
		vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU],1" />
</og:viewLink>

<!--
<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="TABLE_NAME,TABLENAME_JA" />
-->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="null" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="TBLSYU,TABLE_NAME"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF05" /></strong></legend>
		<og:submit  value="insertGF05" lbl="INSERT" command="INSERT" />
		<og:column  name="DBID"        codeKeyVal="{@DBID_INFO}" td="no" />
		<og:column  name="TABLE_NAME"  size="5" td="no" />
		<og:column  name="SYSTEM_ID"   defaultVal="{@SYSTEM_ID}"   size="5" td="no" />
		<og:column  name="TBLSYU"      defaultVal="T" addNoValue="false" td="no" />
		<og:submit  value="directGF05" lbl="DIRECT" command="INSERT" />
		<og:submit  value="modifyGF05" lbl="MODIFY" command="MODIFY" />
	</fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<og:hidden name="maxRowCount" value="{@maxRowCount}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
