<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2170"
	title	= "XML出力(全DB)"
	date	= "2013/08/06"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
/>

<!-- multiple のリクエスト変数の値から、CSV データを作成します。 -->
<og:value command="SET" action="APPEND" key="TABLES" value="{@TABLE_NAME}" />

<!-- 出力先のベースフォルダ -->
<og:value command="SET" key="BASE_DIR" value="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/data/{@DBID}" />

<table border="1" frame="box" rules="all" >
  <tr><th>XML File</th><th>Name</th><th width="70px">Count</th><th>Message</th></tr>
  <!-- CSVデータを、カンマで分解します。 -->
  <c:forTokens items="${TABLES}" delims="," var="TBL" >
	<og:value command="SET" key="NOT_FOUND_MSG">
		<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
			select * from {@TBL}
		</og:query>
	</og:value>
	<og:text>
	  <tr>
		<td>{@TBL}.xml			</td>
		<td>{@LBL.@TBL}			</td>
		<td class="S9">{@DB.COUNT}	</td>
		<td>{@NOT_FOUND_MSG}		</td>
	  </tr>
	</og:text>

	<og:writeTable
		fileURL        = "{@BASE_DIR}"
		filename       = "{@TBL}.xml"
		writerClass    = "XML"
		encode         = "UTF-8" >
		<og:writeTableParam key="TableName" value="{@TBL}" />
<!-- データ削除のSQLを含める場合は、これを使いますが、基本的には、truncate して xml ファイルを読ませてください。 -->
<!--
		<og:writeTableParam key="First" >
			delete from {@TBL}
		</og:writeTableParam>
-->
	</og:writeTable>
  </c:forTokens>
</table>

<br />
Saved DIR:<br />
<og:text>{@BASE_DIR}</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
