<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9220"
	title	= "特殊(レイアウト指定)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "DELETE" がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}"  />

<og:message lbl="MSG0047" comment="削除処理を行います。" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性を指定しないと、入力不可になります。 -->
<!-- viewFormType="HTMLFormatTextField" を使用する場合は、skip="true"が必要です。 -->
<og:view
	viewFormType = "HTMLFormatTextField"
	command    = "{@command}"
	startNo    = "{@startNo}"
	skip       = "true"
>
	<!-- 表示画面のレイアウトは、別ファイル(include_view.jsp)にして、共通利用しています。 -->
	<jsp:directive.include file="include_view.jsp" />
</og:view>

<!-- 登録データは、entry.jsp に送られます。-->
<!-- ここでは、各ページで登録方法（INSERT,UPDATE,DELETE）を指定して、entry.jspを共通で使用します。-->
<!-- 下記に示す方法は、SQL文の直接記述方式です。-->

<og:hidden name="SQL" >
  <jsp:text>
	DELETE FROM GF41
	WHERE SYSTEM_ID = [SYSTEM_ID]
	AND   LANG		= [LANG]
	AND   CLM		= [CLM]
  </jsp:text>
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
