<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9620"
	title	= "メール送信（確認不要）"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- 添付ファイルのサイズ制限は4M(4*1024*1024=4194304) となります。-->
<og:upload
	fileURL  	= "{@USER.ID}"
	scope  		= "request"
	maxPostSize	= "4194304"
/>

<!-- メール内容確認なしで送信する場合は action="NOCHECK"と設定します。-->
<og:mailSender2 
	ptnId		= "{@PTN_ID}" 
	from		= "{@FROM_ID}" 
	to			= "{@TO_ID}" 
	cc			= "{@CC_ID}" 
	bcc			= "{@BCC_ID}" 
	action		= "NOCHECK"
	addrCheck 	= "{@ADDRCHECK}"
	useStop     = "{@USESTOP}"
	debug		= "false"
	fileURL		= "{@USER.ID}"
	filename	= "{@file1},{@file2},{@file3},{@file4},{@file5}"
 />

<!-- タグ mailSender2 実行の戻り値として、エラーコード：0(エラーなし)、1：(エラーあり)。-->
<!-- エラーなしの場合、送信結果を表示させます。-->

<og:equals val1="{@MAIL.ERR_CODE}" val2="0" >
	<!-- view タグの scope 属性設定は mailSender2 タグの scope 属性の設定値と一致させる必要があります。-->
	<og:view 
		noMessage		= "true" 
		pageSize	 	= "500"
		writable		= "false" 
		useScrollBar	= "false" 
		useHilightRow	= "false" 
	/>
</og:equals>
<!-- エラーありの場合、エラー時の後続処理を行います。-->
<og:equals val1="{@MAIL.ERR_CODE}" val2="0" notEquals="true" >
	<og:text>Error Process</og:text>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
