<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA05"
	title	= "セッション切断"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1 = "close" val2 = "{@ACTION}" >
  <og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		SELECT SID,SERIAL#,
		'ALTER SYSTEM KILL SESSION ''' || SID || ',' || SERIAL# || '''' as DELETE_SID,
		SCHEMANAME as SCHEMA,OSUSER,MACHINE,MODULE,ACTION,CLIENT_INFO,TYPE,PROGRAM,LOGON_TIME,STATUS
		FROM V$SESSION
	<og:where>
		<og:and value="SCHEMANAME = '{@SCHEMANAME}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SID,SERIAL#" />
  </og:query>
  <og:viewLink command="{@command}">
	<og:link column="DELETE_SID" href="entry.jsp" target="RESULT"
			keys="command,SQL,DBID" vals="ENTRY,[DELETE_SID],{@DBID}" lbl="MSG0058" />
  </og:viewLink>
</og:equals>

<og:equals val1 = "object" val2 = "{@ACTION}" >
  <og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		SELECT
		    OBJECT_NAME ,
		    OBJECT_TYPE ,
			CREATED ,
		    LAST_DDL_TIME  ,
		    TIMESTAMP ,
			STATUS
		FROM USER_OBJECTS
		WHERE OBJECT_NAME LIKE '%'
		ORDER BY OBJECT_TYPE,OBJECT_NAME
  </og:query>
  <og:viewLink command="{@command}">
	<og:link column="OBJECT_NAME" href="display.jsp" target="_blank"
		keys="command,TYPE,NAME,DBID" vals="NEW,[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
  </og:viewLink>
</og:equals>

<og:equals val1 = "vcursor" val2 = "{@ACTION}" >
  <og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		select count(*),SQL_TEXT from V$OPEN_CURSOR group by SQL_TEXT
		order by 1 desc
  </og:query>
</og:equals>

<og:equals val1 = "sqlarea" val2 = "{@ACTION}" >
  <og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		select * from (
			select
			   EXECUTIONS      EXEC,
			   LOADS           LOADS,
			   PARSE_CALLS     PARSE,
			   DISK_READS      READS,
			   BUFFER_GETS     GETS,
			   ROWS_PROCESSED  ROWS_PROC,
			   SORTS           SORTS,
			   SQL_TEXT
			from
			   V$SQLAREA
		<og:appear startKey = "ORDER BY" value = "{@SQL_ORDER_BY}"
				defaultVal = "EXECUTIONS DESC" />
		) WHERE ROWNUM &lt; {@TOP}+1
  </og:query>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
