<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:key name="ext" match="method/htmlExtend" use="htmlExtend" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <xsl:variable name="version" select="version" />
    <ROWSET tableName="GF36">
      <EXEC_SQL>delete from GF36 where VERSION = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="classDoc">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="className" />
          </xsl:attribute>
          <VERSION		><xsl:value-of select="$version"	/></VERSION>
          <FULLNAME		><xsl:value-of select="fullName"	/></FULLNAME>
          <CLASSNAME	><xsl:value-of select="className"	/></CLASSNAME>
          <CLASSGROUP	><xsl:value-of select="classGroup"	/></CLASSGROUP>
          <MODIFIERS	><xsl:value-of select="modifiers"	/></MODIFIERS>
          <SUPERCLASS	><xsl:value-of select="superClass"	/></SUPERCLASS>
          <INTERFACE	><xsl:value-of select="interface"	/></INTERFACE>
          <CREATEVER	><xsl:value-of select="createVer"	/></CREATEVER>
          <AUTHOR		><xsl:value-of select="author"		/></AUTHOR>
          <SINCE		><xsl:value-of select="since"		/></SINCE>
          <DESCRIPTION	><xsl:value-of select="description"	/></DESCRIPTION>
          <CONTENTS		><xsl:value-of select="contents"	/></CONTENTS>
          <FORM_SAMPLE	><xsl:value-of select="formSample"	/></FORM_SAMPLE>
          <HISTORY		><xsl:value-of select="history"		/></HISTORY>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
