<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "24_ERRMSG"
	title	= "ｴﾗｰﾒｯｾｰｼﾞ編集"
	date	= "2012/04/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>
<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
	<!-- データが選ばれていなければエラー -->
	<og:columnCheck command="{@command}" >
		<jsp:directive.include file="/jsp/common/history_back.jsp" />
	</og:columnCheck>
<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" />

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<!-- viewFormTypeは可能な限りHTMLTableを使用します-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "UNIQ,SNAME,FGLOAD,SYSTEM_ID,LANG,RDC_CODE,RELEASE_NOTES,DYUPD,CDKH,FGJ,KBSAKU,KBLBL"
	noWritable = "{@noWritable}"/>

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
